/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FloatVector
implements NumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<FloatVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<FloatVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<FloatVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final float[] values;

    private FloatVector(float[] values, boolean nocopy) {
        this.values = nocopy ? values : (float[])values.clone();
    }

    public FloatVector(float[] values) {
        this.values = (float[])values.clone();
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Float getValue(int dimension) {
        return Float.valueOf(this.values[dimension]);
    }

    @Override
    public double doubleValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public float floatValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public long longValue(int dimension) {
        return (long)this.values[dimension];
    }

    @Override
    public double[] toArray() {
        double[] data = new double[this.values.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.values[i];
        }
        return data;
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            featureLine.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            featureLine.append(" ");
        }
        return featureLine.toString();
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<FloatVector> {
        @Override
        public FloatVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = ByteArrayUtil.readUnsignedVarint(buffer);
            assert (buffer.remaining() >= 4 * dimensionality);
            float[] values = new float[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getFloat();
            }
            return new FloatVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, FloatVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (buffer.remaining() >= 4 * vec.values.length);
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putFloat(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(FloatVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return ByteArrayUtil.getUnsignedVarintSize(vec.values.length) + 4 * vec.values.length;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<FloatVector> {
        @Override
        public FloatVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.getShort();
            assert (buffer.remaining() >= 4 * dimensionality);
            float[] values = new float[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getFloat();
            }
            return new FloatVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, FloatVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (buffer.remaining() >= 4 * vec.values.length);
            buffer.putShort((short)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putFloat(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(FloatVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 4 * vec.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<FloatVector> {
        @Override
        public FloatVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.get();
            assert (buffer.remaining() >= 4 * dimensionality);
            float[] values = new float[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getFloat();
            }
            return new FloatVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, FloatVector vec) throws IOException {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (buffer.remaining() >= 4 * vec.values.length);
            buffer.put((byte)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putFloat(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(FloatVector vec) {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 4 * vec.getDimensionality();
        }
    }

    public static class Factory
    implements NumberVector.Factory<FloatVector> {
        @Override
        public <A> FloatVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            float[] values = new float[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).floatValue();
            }
            return new FloatVector(values, true);
        }

        @Override
        public <A> FloatVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            float[] values = new float[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getFloat(array, i);
            }
            return new FloatVector(values, true);
        }

        @Override
        public ByteBufferSerializer<FloatVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super FloatVector> getRestrictionClass() {
            return FloatVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

