/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import java.util.regex.Pattern;

public class HierarchicalClassLabel
extends ClassLabel {
    public static final Pattern DEFAULT_SEPARATOR = Pattern.compile("\\.");
    public static final String DEFAULT_SEPARATOR_STRING = ".";
    public static final SimpleTypeInformation<HierarchicalClassLabel> TYPE = new SimpleTypeInformation<HierarchicalClassLabel>(HierarchicalClassLabel.class);
    private Pattern separatorPattern;
    private String separatorString;
    private Comparable<?>[] levelwiseNames;

    public HierarchicalClassLabel(String name, Pattern regex, String separator) {
        this.separatorPattern = regex;
        this.separatorString = separator;
        String[] levelwiseStrings = this.separatorPattern.split(name);
        this.levelwiseNames = new Comparable[levelwiseStrings.length];
        for (int i = 0; i < levelwiseStrings.length; ++i) {
            try {
                this.levelwiseNames[i] = Integer.valueOf(levelwiseStrings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.levelwiseNames[i] = levelwiseStrings[i];
            }
        }
    }

    public HierarchicalClassLabel(String label) {
        this(label, DEFAULT_SEPARATOR, DEFAULT_SEPARATOR_STRING);
    }

    @Override
    public int compareTo(ClassLabel o) {
        HierarchicalClassLabel h = (HierarchicalClassLabel)o;
        for (int i = 0; i < this.levelwiseNames.length && i < h.levelwiseNames.length; ++i) {
            int comp = 0;
            try {
                Comparable<?> first = this.levelwiseNames[i];
                Comparable<?> second = h.levelwiseNames[i];
                comp = first.compareTo(second);
            }
            catch (RuntimeException e) {
                String h1 = (String)(this.levelwiseNames[i] instanceof Integer ? this.levelwiseNames[i].toString() : this.levelwiseNames[i]);
                String h2 = (String)(h.levelwiseNames[i] instanceof Integer ? h.levelwiseNames[i].toString() : h.levelwiseNames[i]);
                comp = h1.compareTo(h2);
            }
            if (comp == 0) continue;
            return comp;
        }
        return this.levelwiseNames.length < h.levelwiseNames.length ? -1 : (this.levelwiseNames.length == h.levelwiseNames.length ? 0 : 1);
    }

    public int depth() {
        return this.levelwiseNames.length - 1;
    }

    public String getNameAt(int level) {
        return this.levelwiseNames[level] instanceof Integer ? this.levelwiseNames[level].toString() : (String)((Object)this.levelwiseNames[level]);
    }

    @Override
    public String toString() {
        return this.toString(this.levelwiseNames.length);
    }

    public String toString(int level) {
        if (level > this.levelwiseNames.length) {
            throw new IllegalArgumentException("Specified level exceeds depth of hierarchy.");
        }
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            name.append(this.getNameAt(i));
            if (i >= level - 1) continue;
            name.append(this.separatorString);
        }
        return name.toString();
    }

    public static class Factory
    extends ClassLabel.Factory<HierarchicalClassLabel> {
        @Override
        public HierarchicalClassLabel makeFromString(String lbl) {
            HierarchicalClassLabel l = (HierarchicalClassLabel)this.existing.get(lbl = lbl.intern());
            if (l == null) {
                l = new HierarchicalClassLabel(lbl);
                this.existing.put(lbl, l);
            }
            return l;
        }

        @Override
        public SimpleTypeInformation<? super HierarchicalClassLabel> getTypeInformation() {
            return TYPE;
        }
    }
}

