/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import java.util.Arrays;

public class HyperBoundingBox
implements SpatialComparable,
Externalizable {
    private static final long serialVersionUID = 1L;
    double[] min;
    double[] max;

    public HyperBoundingBox() {
    }

    public HyperBoundingBox(double[] min, double[] max) {
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max need same dimensionality");
        }
        this.min = min;
        this.max = max;
    }

    public HyperBoundingBox(SpatialComparable other) {
        int dim = other.getDimensionality();
        this.min = new double[dim];
        this.max = new double[dim];
        for (int i = 0; i < dim; ++i) {
            this.min[i] = other.getMin(i);
            this.max[i] = other.getMax(i);
        }
    }

    @Override
    public double getMin(int dimension) {
        return this.min[dimension];
    }

    @Override
    public double getMax(int dimension) {
        return this.max[dimension];
    }

    @Override
    public int getDimensionality() {
        return this.min.length;
    }

    public String toString() {
        return "[Min(" + FormatUtil.format(this.min, ",") + "), Max(" + FormatUtil.format(this.max, ",") + ")]";
    }

    public String toString(String pre, NumberFormat nf) {
        return pre + "[Min(" + FormatUtil.format(this.min, ",", nf) + "), Max(" + FormatUtil.format(this.max, ",", nf) + ")]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof HyperBoundingBox)) {
            return false;
        }
        HyperBoundingBox box = (HyperBoundingBox)obj;
        return Arrays.equals(this.min, box.min) && Arrays.equals(this.max, box.max);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int dim = this.getDimensionality();
        out.writeInt(dim);
        for (double aMin : this.min) {
            out.writeDouble(aMin);
        }
        for (double aMax : this.max) {
            out.writeDouble(aMax);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int i;
        int dim = in.readInt();
        this.min = new double[dim];
        this.max = new double[dim];
        for (i = 0; i < this.min.length; ++i) {
            this.min[i] = in.readDouble();
        }
        for (i = 0; i < this.max.length; ++i) {
            this.max[i] = in.readDouble();
        }
    }
}

