/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class IntegerVector
implements NumberVector {
    public static final Factory STATIC = new Factory();
    public static final ByteBufferSerializer<IntegerVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<IntegerVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<IntegerVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final int[] values;

    private IntegerVector(int[] values, boolean nocopy) {
        if (nocopy) {
            this.values = values;
        } else {
            this.values = new int[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        }
    }

    public IntegerVector(int[] values) {
        this.values = (int[])values.clone();
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Integer getValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public double doubleValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public long longValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public int intValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public double[] toArray() {
        double[] data = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            data[i] = this.values[i];
        }
        return data;
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            featureLine.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            featureLine.append(" ");
        }
        return featureLine.toString();
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<IntegerVector> {
        @Override
        public IntegerVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = ByteArrayUtil.readUnsignedVarint(buffer);
            assert (buffer.remaining() >= 4 * dimensionality);
            int[] values = new int[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = ByteArrayUtil.readSignedVarint(buffer);
            }
            return new IntegerVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, IntegerVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                ByteArrayUtil.writeSignedVarint(buffer, vec.values[i]);
            }
        }

        @Override
        public int getByteSize(IntegerVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            int len = ByteArrayUtil.getUnsignedVarintSize(vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                len += ByteArrayUtil.getSignedVarintSize(vec.values[i]);
            }
            return len;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<IntegerVector> {
        @Override
        public IntegerVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.getShort();
            assert (buffer.remaining() >= 4 * dimensionality);
            int[] values = new int[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getInt();
            }
            return new IntegerVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, IntegerVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (buffer.remaining() >= 4 * vec.values.length);
            buffer.putShort((short)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putInt(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(IntegerVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 4 * vec.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<IntegerVector> {
        @Override
        public IntegerVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.get();
            assert (buffer.remaining() >= 4 * dimensionality);
            int[] values = new int[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getInt();
            }
            return new IntegerVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, IntegerVector vec) throws IOException {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (buffer.remaining() >= 4 * vec.values.length);
            buffer.put((byte)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putInt(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(IntegerVector vec) {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 4 * vec.getDimensionality();
        }
    }

    public static class Factory
    implements NumberVector.Factory<IntegerVector> {
        @Override
        public <A> IntegerVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            int[] values = new int[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).intValue();
            }
            return new IntegerVector(values, true);
        }

        @Override
        public <A> IntegerVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            int[] values = new int[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getInteger(array, i);
            }
            return new IntegerVector(values, true);
        }

        @Override
        public ByteBufferSerializer<IntegerVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super IntegerVector> getRestrictionClass() {
            return IntegerVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

