/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;

public class LabelList {
    public static final ByteBufferSerializer<LabelList> SERIALIZER = new Serializer();
    private String[] labels;
    public static final LabelList EMPTY_LABELS = new LabelList(0);

    private LabelList(int initialCapacity) {
        this.labels = new String[initialCapacity];
    }

    protected LabelList(String[] array) {
        this.labels = array;
    }

    public static LabelList make(Collection<String> labels) {
        int size = labels.size();
        if (size == 0) {
            return EMPTY_LABELS;
        }
        return new LabelList(labels.toArray(new String[size]));
    }

    public int size() {
        return this.labels.length;
    }

    public String get(int i) {
        return this.labels[i];
    }

    public String toString() {
        return FormatUtil.format(this.labels, " ");
    }

    public static class Serializer
    implements ByteBufferSerializer<LabelList> {
        @Override
        public LabelList fromByteBuffer(ByteBuffer buffer) throws IOException {
            int cnt = ByteArrayUtil.readUnsignedVarint(buffer);
            LabelList ret = new LabelList(cnt);
            for (int i = 0; i < cnt; ++i) {
                ((LabelList)ret).labels[i] = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
            }
            return ret;
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, LabelList object) throws IOException {
            int cnt = object.labels.length;
            ByteArrayUtil.writeUnsignedVarint(buffer, cnt);
            for (int i = 0; i < cnt; ++i) {
                ByteArrayUtil.STRING_SERIALIZER.toByteBuffer(buffer, object.labels[i]);
            }
        }

        @Override
        public int getByteSize(LabelList object) throws IOException {
            int cnt = object.labels.length;
            int size = ByteArrayUtil.getUnsignedVarintSize(cnt);
            for (int i = 0; i < cnt; ++i) {
                size += ByteArrayUtil.STRING_SERIALIZER.getByteSize(object.labels[i]);
            }
            return size;
        }
    }
}

