/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import java.util.Arrays;

public class ModifiableHyperBoundingBox
extends HyperBoundingBox {
    private static final long serialVersionUID = 1L;

    public ModifiableHyperBoundingBox() {
    }

    public ModifiableHyperBoundingBox(SpatialComparable hbb) {
        super(SpatialUtil.getMin(hbb), SpatialUtil.getMax(hbb));
    }

    public ModifiableHyperBoundingBox(double[] min, double[] max) {
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max need same dimensionality");
        }
        this.min = min;
        this.max = max;
    }

    public ModifiableHyperBoundingBox(int dim, double min, double max) {
        this.min = new double[dim];
        this.max = new double[dim];
        Arrays.fill(this.min, min);
        Arrays.fill(this.max, max);
    }

    public void setMax(int dimension, double value) {
        this.max[dimension] = value;
    }

    public void setMin(int dimension, double value) {
        this.min[dimension] = value;
    }

    public double[] getMinRef() {
        return this.min;
    }

    public double[] getMaxRef() {
        return this.max;
    }

    public void set(SpatialComparable obj) {
        int dim = this.min.length;
        assert (obj.getDimensionality() == dim);
        if (obj instanceof ModifiableHyperBoundingBox) {
            ModifiableHyperBoundingBox ho = (ModifiableHyperBoundingBox)obj;
            System.arraycopy(ho.getMinRef(), 0, this.min, 0, dim);
            System.arraycopy(ho.getMaxRef(), 0, this.max, 0, dim);
            return;
        }
        for (int i = 0; i < dim; ++i) {
            this.min[i] = obj.getMin(i);
            this.max[i] = obj.getMax(i);
        }
    }

    public boolean extend(SpatialComparable obj) {
        int dim = this.min.length;
        assert (obj.getDimensionality() == dim);
        boolean extended = false;
        for (int i = 0; i < dim; ++i) {
            double omin = obj.getMin(i);
            double omax = obj.getMax(i);
            if (omin < this.min[i]) {
                this.min[i] = omin;
                extended = true;
            }
            if (!(omax > this.max[i])) continue;
            this.max[i] = omax;
            extended = true;
        }
        return extended;
    }
}

