/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class OneDimensionalDoubleVector
implements NumberVector {
    public static final Factory STATIC = new Factory();
    double val;

    public OneDimensionalDoubleVector(double val) {
        this.val = val;
    }

    @Override
    public int getDimensionality() {
        return 1;
    }

    @Override
    public double doubleValue(int dimension) {
        assert (dimension == 0) : "Non-existant dimension accessed.";
        return this.val;
    }

    @Override
    public long longValue(int dimension) {
        assert (dimension == 0) : "Non-existant dimension accessed.";
        return (long)this.val;
    }

    @Override
    public double[] toArray() {
        return new double[]{this.val};
    }

    public static class Factory
    implements NumberVector.Factory<OneDimensionalDoubleVector> {
        @Override
        public <A> OneDimensionalDoubleVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            assert (adapter.size(array) == 1) : "Incorrect dimensionality for 1-dimensional vector.";
            return new OneDimensionalDoubleVector(adapter.get(array, 0).doubleValue());
        }

        @Override
        public <A> OneDimensionalDoubleVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            assert (adapter.size(array) == 1) : "Incorrect dimensionality for 1-dimensional vector.";
            return new OneDimensionalDoubleVector(adapter.getDouble(array, 0));
        }

        @Override
        public ByteBufferSerializer<OneDimensionalDoubleVector> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super OneDimensionalDoubleVector> getRestrictionClass() {
            return OneDimensionalDoubleVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

