/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ShortVector
implements NumberVector {
    public static final Factory STATIC = new Factory();
    public static final ByteBufferSerializer<ShortVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<ShortVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final short[] values;

    private ShortVector(short[] values, boolean nocopy) {
        if (nocopy) {
            this.values = values;
        } else {
            this.values = new short[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        }
    }

    public ShortVector(short[] values) {
        this.values = (short[])values.clone();
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Short getValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public double doubleValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public long longValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public short shortValue(int dimension) {
        return this.values[dimension];
    }

    public short[] getValues() {
        short[] copy = new short[this.values.length];
        System.arraycopy(this.values, 0, copy, 0, this.values.length);
        return copy;
    }

    @Override
    public double[] toArray() {
        double[] data = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            data[i] = this.values[i];
        }
        return data;
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            featureLine.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            featureLine.append(" ");
        }
        return featureLine.toString();
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<ShortVector> {
        @Override
        public ShortVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = ByteArrayUtil.readUnsignedVarint(buffer);
            assert (buffer.remaining() >= 4 * dimensionality);
            short[] values = new short[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = (short)ByteArrayUtil.readSignedVarint(buffer);
            }
            return new ShortVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, ShortVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                ByteArrayUtil.writeSignedVarint(buffer, vec.values[i]);
            }
        }

        @Override
        public int getByteSize(ShortVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            int len = ByteArrayUtil.getUnsignedVarintSize(vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                len += ByteArrayUtil.getSignedVarintSize(vec.values[i]);
            }
            return len;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<ShortVector> {
        @Override
        public ShortVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.getShort();
            assert (buffer.remaining() >= 2 * dimensionality);
            short[] values = new short[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getShort();
            }
            return new ShortVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, ShortVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (buffer.remaining() >= 2 * vec.values.length);
            buffer.putShort((short)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putShort(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(ShortVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 2 * vec.getDimensionality();
        }
    }

    public static class Factory
    implements NumberVector.Factory<ShortVector> {
        @Override
        public <A> ShortVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            short[] values = new short[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).shortValue();
            }
            return new ShortVector(values, true);
        }

        @Override
        public <A> ShortVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            short[] values = new short[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getShort(array, i);
            }
            return new ShortVector(values, true);
        }

        @Override
        public ByteBufferSerializer<ShortVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super ShortVector> getRestrictionClass() {
            return ShortVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

