/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SparseByteVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<SparseByteVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final int[] indexes;
    private final byte[] values;
    private int dimensionality;
    private static final Byte BYTE0 = 0;

    public SparseByteVector(int[] indexes, byte[] values, int dimensionality) {
        this.indexes = indexes;
        this.values = values;
        this.dimensionality = dimensionality;
    }

    public SparseByteVector(Int2DoubleOpenHashMap values, int dimensionality) throws IllegalArgumentException {
        if (values.size() > dimensionality) {
            throw new IllegalArgumentException("values.size() > dimensionality!");
        }
        this.indexes = new int[values.size()];
        this.values = new byte[values.size()];
        ObjectIterator<Int2DoubleMap.Entry> iter = values.int2DoubleEntrySet().fastIterator();
        int i = 0;
        while (iter.hasNext()) {
            this.indexes[i] = ((Int2DoubleMap.Entry)iter.next()).getIntKey();
            ++i;
        }
        Arrays.sort(this.indexes);
        for (int i2 = 0; i2 < values.size(); ++i2) {
            this.values[i2] = (byte)values.get(this.indexes[i2]);
        }
        this.dimensionality = dimensionality;
        int maxdim = this.getMaxDim();
        if (maxdim > dimensionality) {
            throw new IllegalArgumentException("Given dimensionality " + dimensionality + " is too small w.r.t. the given values (occurring maximum: " + maxdim + ").");
        }
    }

    private int getMaxDim() {
        return this.indexes.length == 0 ? 0 : this.indexes[this.indexes.length - 1];
    }

    public SparseByteVector(byte[] values) throws IllegalArgumentException {
        this.dimensionality = values.length;
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            ++size;
        }
        this.indexes = new int[size];
        this.values = new byte[size];
        int pos = 0;
        for (int i = 0; i < values.length; ++i) {
            byte value = values[i];
            if (value == 0) continue;
            this.indexes[pos] = i;
            this.values[pos] = value;
            ++pos;
        }
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int dimensionality) throws IllegalArgumentException {
        int maxdim = this.getMaxDim();
        if (maxdim > dimensionality) {
            throw new IllegalArgumentException("Given dimensionality " + dimensionality + " is too small w.r.t. the given values (occurring maximum: " + maxdim + ").");
        }
        this.dimensionality = dimensionality;
    }

    @Override
    @Deprecated
    public Byte getValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? this.values[pos] : BYTE0;
    }

    @Override
    @Deprecated
    public double doubleValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? (double)this.values[pos] : 0.0;
    }

    @Override
    @Deprecated
    public long longValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? (long)this.values[pos] : 0L;
    }

    @Override
    public byte byteValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? this.values[pos] : (byte)0;
    }

    @Override
    public double[] toArray() {
        double[] vals = new double[this.dimensionality];
        for (int i = 0; i < this.indexes.length; ++i) {
            vals[this.indexes[i]] = this.values[i];
        }
        return vals;
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder(8 * this.indexes.length).append(this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            featureLine.append(" ").append(this.indexes[i]).append(" ").append(this.values[i]);
        }
        return featureLine.toString();
    }

    @Override
    public int iterDim(int iter) {
        return this.indexes[iter];
    }

    @Override
    public boolean iterValid(int iter) {
        return iter < this.indexes.length;
    }

    @Override
    public double iterDoubleValue(int iter) {
        return this.values[iter];
    }

    @Override
    public long iterLongValue(int iter) {
        return this.values[iter];
    }

    @Override
    public byte iterByteValue(int iter) {
        return this.values[iter];
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<SparseByteVector> {
        @Override
        public SparseByteVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = ByteArrayUtil.readUnsignedVarint(buffer);
            int nonzero = ByteArrayUtil.readUnsignedVarint(buffer);
            int[] dims = new int[nonzero];
            byte[] values = new byte[nonzero];
            for (int i = 0; i < nonzero; ++i) {
                dims[i] = ByteArrayUtil.readUnsignedVarint(buffer);
                values[i] = buffer.get();
            }
            return new SparseByteVector(dims, values, dimensionality);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, SparseByteVector vec) throws IOException {
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.dimensionality);
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                ByteArrayUtil.writeUnsignedVarint(buffer, vec.indexes[i]);
                buffer.put(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(SparseByteVector vec) {
            int sum = 0;
            sum += ByteArrayUtil.getUnsignedVarintSize(vec.dimensionality);
            sum += ByteArrayUtil.getUnsignedVarintSize(vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                sum += ByteArrayUtil.getUnsignedVarintSize(vec.indexes[i]);
                ++sum;
            }
            return sum;
        }
    }

    public static class Factory
    implements SparseNumberVector.Factory<SparseByteVector> {
        @Override
        public <A> SparseByteVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            byte[] values = new byte[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).byteValue();
            }
            return new SparseByteVector(values);
        }

        @Override
        public <A> SparseByteVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            byte[] values = new byte[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getByte(array, i);
            }
            return new SparseByteVector(values);
        }

        @Override
        public SparseByteVector newNumberVector(Int2DoubleOpenHashMap values, int maxdim) {
            return new SparseByteVector(values, maxdim);
        }

        @Override
        public ByteBufferSerializer<SparseByteVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super SparseByteVector> getRestrictionClass() {
            return SparseByteVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

