/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SparseFloatVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<SparseFloatVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private static final float FLOAT0 = 0.0f;
    private final int[] indexes;
    private final float[] values;
    private int dimensionality;

    public SparseFloatVector(int[] indexes, float[] values, int dimensionality) {
        this.indexes = indexes;
        this.values = values;
        this.dimensionality = dimensionality;
    }

    public SparseFloatVector(Int2FloatOpenHashMap values, int dimensionality) throws IllegalArgumentException {
        if (values.size() > dimensionality) {
            throw new IllegalArgumentException("values.size() > dimensionality!");
        }
        this.indexes = new int[values.size()];
        this.values = new float[values.size()];
        ObjectIterator<Int2FloatMap.Entry> iter = values.int2FloatEntrySet().fastIterator();
        int i = 0;
        while (iter.hasNext()) {
            this.indexes[i] = ((Int2FloatMap.Entry)iter.next()).getIntKey();
            ++i;
        }
        Arrays.sort(this.indexes);
        for (int i2 = 0; i2 < values.size(); ++i2) {
            this.values[i2] = values.get(this.indexes[i2]);
        }
        this.dimensionality = dimensionality;
        int maxdim = this.getMaxDim();
        if (maxdim > dimensionality) {
            throw new IllegalArgumentException("Given dimensionality " + dimensionality + " is too small w.r.t. the given values (occurring maximum: " + maxdim + ").");
        }
    }

    private int getMaxDim() {
        return this.indexes.length == 0 ? 0 : this.indexes[this.indexes.length - 1];
    }

    public SparseFloatVector(float[] values) throws IllegalArgumentException {
        this.dimensionality = values.length;
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0f) continue;
            ++size;
        }
        this.indexes = new int[size];
        this.values = new float[size];
        int pos = 0;
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            if (value == 0.0f) continue;
            this.indexes[pos] = i;
            this.values[pos] = value;
            ++pos;
        }
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int dimensionality) throws IllegalArgumentException {
        int maxdim = this.getMaxDim();
        if (maxdim > dimensionality) {
            throw new IllegalArgumentException("Given dimensionality " + dimensionality + " is too small w.r.t. the given values (occurring maximum: " + maxdim + ").");
        }
        this.dimensionality = dimensionality;
    }

    @Override
    @Deprecated
    public Float getValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return Float.valueOf(pos >= 0 ? this.values[pos] : 0.0f);
    }

    @Override
    @Deprecated
    public double doubleValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? (double)this.values[pos] : 0.0;
    }

    @Override
    @Deprecated
    public float floatValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? this.values[pos] : 0.0f;
    }

    @Override
    @Deprecated
    public long longValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? (long)this.values[pos] : 0L;
    }

    @Override
    public double[] toArray() {
        double[] vals = new double[this.dimensionality];
        for (int i = 0; i < this.indexes.length; ++i) {
            vals[this.indexes[i]] = this.values[i];
        }
        return vals;
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder(15 * this.indexes.length).append(this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            featureLine.append(" ").append(this.indexes[i]).append(" ").append(this.values[i]);
        }
        return featureLine.toString();
    }

    @Override
    public int iterDim(int iter) {
        return this.indexes[iter];
    }

    @Override
    public boolean iterValid(int iter) {
        return iter < this.indexes.length;
    }

    @Override
    public double iterDoubleValue(int iter) {
        return this.values[iter];
    }

    @Override
    public float iterFloatValue(int iter) {
        return this.values[iter];
    }

    @Override
    public long iterLongValue(int iter) {
        return (long)this.values[iter];
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<SparseFloatVector> {
        @Override
        public SparseFloatVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = ByteArrayUtil.readUnsignedVarint(buffer);
            int nonzero = ByteArrayUtil.readUnsignedVarint(buffer);
            int[] dims = new int[nonzero];
            float[] values = new float[nonzero];
            for (int i = 0; i < nonzero; ++i) {
                dims[i] = ByteArrayUtil.readUnsignedVarint(buffer);
                values[i] = buffer.getFloat();
            }
            return new SparseFloatVector(dims, values, dimensionality);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, SparseFloatVector vec) throws IOException {
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.dimensionality);
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                ByteArrayUtil.writeUnsignedVarint(buffer, vec.indexes[i]);
                buffer.putFloat(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(SparseFloatVector vec) {
            int sum = 0;
            sum += ByteArrayUtil.getUnsignedVarintSize(vec.dimensionality);
            sum += ByteArrayUtil.getUnsignedVarintSize(vec.values.length);
            for (int d : vec.indexes) {
                sum += ByteArrayUtil.getUnsignedVarintSize(d);
            }
            return sum += vec.values.length * 4;
        }
    }

    public static class Factory
    implements SparseNumberVector.Factory<SparseFloatVector> {
        @Override
        public <A> SparseFloatVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            float[] values = new float[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).floatValue();
            }
            return new SparseFloatVector(values);
        }

        @Override
        public <A> SparseFloatVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            float[] values = new float[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getFloat(array, i);
            }
            return new SparseFloatVector(values);
        }

        @Override
        public SparseFloatVector newNumberVector(Int2DoubleOpenHashMap dvalues, int maxdim) {
            int[] indexes = new int[dvalues.size()];
            float[] values = new float[dvalues.size()];
            ObjectIterator<Int2DoubleMap.Entry> iter = dvalues.int2DoubleEntrySet().fastIterator();
            int i = 0;
            while (iter.hasNext()) {
                indexes[i] = ((Int2DoubleMap.Entry)iter.next()).getIntKey();
                ++i;
            }
            Arrays.sort(indexes);
            for (i = 0; i < dvalues.size(); ++i) {
                values[i] = (float)dvalues.get(indexes[i]);
            }
            return new SparseFloatVector(indexes, values, maxdim);
        }

        @Override
        public ByteBufferSerializer<SparseFloatVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super SparseFloatVector> getRestrictionClass() {
            return SparseFloatVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

