/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SparseIntegerVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<SparseIntegerVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private static final int INT0 = 0;
    private final int[] indexes;
    private final int[] values;
    private int dimensionality;

    public SparseIntegerVector(int[] indexes, int[] values, int dimensionality) {
        this.indexes = indexes;
        this.values = values;
        this.dimensionality = dimensionality;
    }

    public SparseIntegerVector(Int2DoubleOpenHashMap values, int dimensionality) throws IllegalArgumentException {
        if (values.size() > dimensionality) {
            throw new IllegalArgumentException("values.size() > dimensionality!");
        }
        this.indexes = new int[values.size()];
        this.values = new int[values.size()];
        ObjectIterator<Int2DoubleMap.Entry> iter = values.int2DoubleEntrySet().fastIterator();
        int i = 0;
        while (iter.hasNext()) {
            this.indexes[i] = ((Int2DoubleMap.Entry)iter.next()).getIntKey();
            ++i;
        }
        Arrays.sort(this.indexes);
        for (int i2 = 0; i2 < values.size(); ++i2) {
            this.values[i2] = (int)values.get(this.indexes[i2]);
        }
        this.dimensionality = dimensionality;
        int maxdim = this.getMaxDim();
        if (maxdim > dimensionality) {
            throw new IllegalArgumentException("Given dimensionality " + dimensionality + " is too small w.r.t. the given values (occurring maximum: " + maxdim + ").");
        }
    }

    private int getMaxDim() {
        return this.indexes.length == 0 ? 0 : this.indexes[this.indexes.length - 1];
    }

    public SparseIntegerVector(int[] values) throws IllegalArgumentException {
        this.dimensionality = values.length;
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            ++size;
        }
        this.indexes = new int[size];
        this.values = new int[size];
        int pos = 0;
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            if (value == 0) continue;
            this.indexes[pos] = i;
            this.values[pos] = value;
            ++pos;
        }
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int dimensionality) throws IllegalArgumentException {
        int maxdim = this.getMaxDim();
        if (maxdim > dimensionality) {
            throw new IllegalArgumentException("Given dimensionality " + dimensionality + " is too small w.r.t. the given values (occurring maximum: " + maxdim + ").");
        }
        this.dimensionality = dimensionality;
    }

    @Override
    @Deprecated
    public Integer getValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? this.values[pos] : INT0;
    }

    @Override
    @Deprecated
    public double doubleValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? (double)this.values[pos] : 0.0;
    }

    @Override
    @Deprecated
    public long longValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? (long)this.values[pos] : 0L;
    }

    @Override
    @Deprecated
    public int intValue(int dimension) {
        int pos = Arrays.binarySearch(this.indexes, dimension);
        return pos >= 0 ? this.values[pos] : 0;
    }

    @Override
    public double[] toArray() {
        double[] vals = new double[this.dimensionality];
        for (int i = 0; i < this.indexes.length; ++i) {
            vals[this.indexes[i]] = this.values[i];
        }
        return vals;
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder(14 * this.indexes.length).append(this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            featureLine.append(" ").append(this.indexes[i]).append(" ").append(this.values[i]);
        }
        return featureLine.toString();
    }

    @Override
    public int iterDim(int iter) {
        return this.indexes[iter];
    }

    @Override
    public boolean iterValid(int iter) {
        return iter < this.indexes.length;
    }

    @Override
    public double iterDoubleValue(int iter) {
        return this.values[iter];
    }

    @Override
    public int iterIntValue(int iter) {
        return this.values[iter];
    }

    @Override
    public long iterLongValue(int iter) {
        return this.values[iter];
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<SparseIntegerVector> {
        @Override
        public SparseIntegerVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = ByteArrayUtil.readUnsignedVarint(buffer);
            int nonzero = ByteArrayUtil.readUnsignedVarint(buffer);
            int[] dims = new int[nonzero];
            int[] values = new int[nonzero];
            for (int i = 0; i < nonzero; ++i) {
                dims[i] = ByteArrayUtil.readUnsignedVarint(buffer);
                values[i] = ByteArrayUtil.readSignedVarint(buffer);
            }
            return new SparseIntegerVector(dims, values, dimensionality);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, SparseIntegerVector vec) throws IOException {
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.dimensionality);
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                ByteArrayUtil.writeUnsignedVarint(buffer, vec.indexes[i]);
                ByteArrayUtil.writeSignedVarint(buffer, vec.values[i]);
            }
        }

        @Override
        public int getByteSize(SparseIntegerVector vec) {
            int sum = 0;
            sum += ByteArrayUtil.getUnsignedVarintSize(vec.dimensionality);
            sum += ByteArrayUtil.getUnsignedVarintSize(vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                sum += ByteArrayUtil.getUnsignedVarintSize(vec.indexes[i]);
                sum += ByteArrayUtil.getSignedVarintSize(vec.values[i]);
            }
            return sum;
        }
    }

    public static class Factory
    implements SparseNumberVector.Factory<SparseIntegerVector> {
        @Override
        public <A> SparseIntegerVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            int[] values = new int[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).intValue();
            }
            return new SparseIntegerVector(values);
        }

        @Override
        public <A> SparseIntegerVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            int[] values = new int[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getInteger(array, i);
            }
            return new SparseIntegerVector(values);
        }

        @Override
        public SparseIntegerVector newNumberVector(Int2DoubleOpenHashMap values, int maxdim) {
            return new SparseIntegerVector(values, maxdim);
        }

        @Override
        public ByteBufferSerializer<SparseIntegerVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super SparseIntegerVector> getRestrictionClass() {
            return SparseIntegerVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

