/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import java.util.Comparator;

public class Subspace {
    private final long[] dimensions;
    private final int dimensionality;
    public static Comparator<Subspace> DIMENSION_COMPARATOR = new Comparator<Subspace>(){

        @Override
        public int compare(Subspace s1, Subspace s2) {
            if (s1 == s2 || s1.getDimensions() == s2.getDimensions()) {
                return 0;
            }
            if (s1.getDimensions() == null) {
                return -1;
            }
            if (s2.getDimensions() == null) {
                return 1;
            }
            int compare = s1.dimensionality() - s2.dimensionality();
            if (compare != 0) {
                return compare;
            }
            int d1 = BitsUtil.nextSetBit(s1.getDimensions(), 0);
            int d2 = BitsUtil.nextSetBit(s2.getDimensions(), 0);
            while (d1 >= 0 && d2 >= 0) {
                if (d1 != d2) {
                    return d1 - d2;
                }
                d1 = BitsUtil.nextSetBit(s1.getDimensions(), d1 + 1);
                d2 = BitsUtil.nextSetBit(s2.getDimensions(), d2 + 1);
            }
            return 0;
        }
    };

    public Subspace(int dimension) {
        this.dimensions = BitsUtil.zero(dimension + 1);
        BitsUtil.setI(this.dimensions, dimension);
        this.dimensionality = 1;
    }

    public Subspace(long[] dimensions) {
        this.dimensions = dimensions;
        this.dimensionality = BitsUtil.cardinality(dimensions);
    }

    public final long[] getDimensions() {
        return this.dimensions;
    }

    public final int dimensionality() {
        return this.dimensionality;
    }

    public Subspace join(Subspace other) {
        long[] newDimensions = this.joinLastDimensions(other);
        return newDimensions != null ? new Subspace(newDimensions) : null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100 + 5 * this.dimensionality).append("Dimensions: [");
        int d = BitsUtil.nextSetBit(this.dimensions, 0);
        while (d >= 0) {
            result.append(d + 1).append(", ");
            d = BitsUtil.nextSetBit(this.dimensions, d + 1);
        }
        if (result.length() >= 2) {
            result.setLength(result.length() - 2);
        }
        return result.append(']').toString();
    }

    public String dimensionsToString() {
        return this.dimensonsToString(", ");
    }

    public String dimensonsToString(String sep) {
        StringBuilder result = new StringBuilder(100).append('[');
        int dim = BitsUtil.nextSetBit(this.dimensions, 0);
        while (dim >= 0) {
            result.append(dim + 1).append(sep);
            dim = BitsUtil.nextSetBit(this.dimensions, dim + 1);
        }
        if (result.length() > sep.length()) {
            result.setLength(result.length() - sep.length());
        }
        return result.append(']').toString();
    }

    public boolean isSubspace(Subspace subspace) {
        return this.dimensionality <= subspace.dimensionality && BitsUtil.intersectionSize(this.dimensions, subspace.dimensions) == this.dimensionality;
    }

    protected long[] joinLastDimensions(Subspace other) {
        if (this.dimensionality != other.dimensionality) {
            return null;
        }
        if (this.dimensionality == 1) {
            return BitsUtil.orI(BitsUtil.copy(this.dimensions), other.dimensions);
        }
        int last1 = BitsUtil.capacity(this.dimensions) - BitsUtil.numberOfLeadingZeros(this.dimensions) - 1;
        int last2 = BitsUtil.capacity(other.dimensions) - BitsUtil.numberOfLeadingZeros(other.dimensions) - 1;
        if (last2 < 0 || last1 >= last2) {
            return null;
        }
        long[] result = BitsUtil.orI(BitsUtil.copy(other.dimensions), this.dimensions);
        return (long[])(BitsUtil.cardinality(result) == this.dimensionality + 1 ? result : null);
    }

    public int hashCode() {
        return BitsUtil.hashCode(this.dimensions);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && BitsUtil.equal(this.dimensions, ((Subspace)obj).dimensions);
    }
}

