/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.util.Comparator;
import java.util.Random;
import net.jafama.FastMath;

public final class VectorUtil {
    private VectorUtil() {
    }

    public static <V extends NumberVector> V randomVector(NumberVector.Factory<V> factory, int dim, Random r) {
        double[] data = new double[dim];
        for (int i = 0; i < dim; ++i) {
            data[i] = r.nextDouble();
        }
        return factory.newNumberVector(data);
    }

    public static <V extends NumberVector> V randomVector(NumberVector.Factory<V> factory, int dim) {
        return VectorUtil.randomVector(factory, dim, new Random());
    }

    public static double angleDense(NumberVector v1, NumberVector v2) {
        double r1;
        int k;
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 <= (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double cross = 0.0;
        double l1 = 0.0;
        double l2 = 0.0;
        for (k = 0; k < mindim; ++k) {
            r1 = v1.doubleValue(k);
            double r2 = v2.doubleValue(k);
            cross += r1 * r2;
            l1 += r1 * r1;
            l2 += r2 * r2;
        }
        for (k = mindim; k < dim1; ++k) {
            r1 = v1.doubleValue(k);
            l1 += r1 * r1;
        }
        for (k = mindim; k < dim2; ++k) {
            double r2 = v2.doubleValue(k);
            l2 += r2 * r2;
        }
        double a = cross == 0.0 ? 0.0 : (l1 == 0.0 || l2 == 0.0 ? 1.0 : FastMath.sqrt(cross / l1 * (cross / l2)));
        return a < 1.0 ? a : 1.0;
    }

    public static double angleSparse(SparseNumberVector v1, SparseNumberVector v2) {
        double l1 = 0.0;
        double l2 = 0.0;
        double cross = 0.0;
        int i1 = v1.iter();
        int i2 = v2.iter();
        while (v1.iterValid(i1) && v2.iterValid(i2)) {
            double val;
            int d2;
            int d1 = v1.iterDim(i1);
            if (d1 < (d2 = v2.iterDim(i2))) {
                val = v1.iterDoubleValue(i1);
                l1 += val * val;
                i1 = v1.iterAdvance(i1);
                continue;
            }
            if (d2 < d1) {
                val = v2.iterDoubleValue(i2);
                l2 += val * val;
                i2 = v2.iterAdvance(i2);
                continue;
            }
            double val1 = v1.iterDoubleValue(i1);
            double val2 = v2.iterDoubleValue(i2);
            l1 += val1 * val1;
            l2 += val2 * val2;
            cross += val1 * val2;
            i1 = v1.iterAdvance(i1);
            i2 = v2.iterAdvance(i2);
        }
        while (v1.iterValid(i1)) {
            double val = v1.iterDoubleValue(i1);
            l1 += val * val;
            i1 = v1.iterAdvance(i1);
        }
        while (v2.iterValid(i2)) {
            double val = v2.iterDoubleValue(i2);
            l2 += val * val;
            i2 = v2.iterAdvance(i2);
        }
        double a = cross == 0.0 ? 0.0 : (l1 == 0.0 || l2 == 0.0 ? 1.0 : FastMath.sqrt(cross / l1 * (cross / l2)));
        return a < 1.0 ? a : 1.0;
    }

    public static double angleSparseDense(SparseNumberVector v1, NumberVector v2) {
        int dim2 = v2.getDimensionality();
        double l1 = 0.0;
        double l2 = 0.0;
        double cross = 0.0;
        int i1 = v1.iter();
        int d2 = 0;
        while (v1.iterValid(i1)) {
            double val;
            int d1 = v1.iterDim(i1);
            while (d2 < d1 && d2 < dim2) {
                val = v2.doubleValue(d2);
                l2 += val * val;
                ++d2;
            }
            if (d2 < dim2) {
                assert (d1 == d2) : "Dimensions not ordered";
                double val1 = v1.iterDoubleValue(i1);
                double val2 = v2.doubleValue(d2);
                l1 += val1 * val1;
                l2 += val2 * val2;
                cross += val1 * val2;
                i1 = v1.iterAdvance(i1);
                ++d2;
                continue;
            }
            val = v1.iterDoubleValue(i1);
            l1 += val * val;
            i1 = v1.iterAdvance(i1);
        }
        while (d2 < dim2) {
            double val = v2.doubleValue(d2);
            l2 += val * val;
            ++d2;
        }
        double a = cross == 0.0 ? 0.0 : (l1 == 0.0 || l2 == 0.0 ? 1.0 : FastMath.sqrt(cross / l1 * (cross / l2)));
        return a < 1.0 ? a : 1.0;
    }

    public static double cosAngle(NumberVector v1, NumberVector v2) {
        return v1 instanceof SparseNumberVector ? (v2 instanceof SparseNumberVector ? VectorUtil.angleSparse((SparseNumberVector)v1, (SparseNumberVector)v2) : VectorUtil.angleSparseDense((SparseNumberVector)v1, v2)) : (v2 instanceof SparseNumberVector ? VectorUtil.angleSparseDense((SparseNumberVector)v2, v1) : VectorUtil.angleDense(v1, v2));
    }

    public static double minCosAngle(SpatialComparable v1, SpatialComparable v2) {
        double max1;
        double min1;
        int k;
        int dim2;
        if (v1 instanceof NumberVector && v2 instanceof NumberVector) {
            return VectorUtil.cosAngle((NumberVector)v1, (NumberVector)v2);
        }
        int dim1 = v1.getDimensionality();
        int mindim = dim1 <= (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double s1 = 0.0;
        double s2 = 0.0;
        double l1 = 0.0;
        double l2 = 0.0;
        for (k = 0; k < mindim; ++k) {
            min1 = v1.getMin(k);
            max1 = v1.getMax(k);
            double min2 = v2.getMin(k);
            double max2 = v2.getMax(k);
            double p1 = min1 * min2;
            double p2 = min1 * max2;
            double p3 = max1 * min2;
            double p4 = max1 * max2;
            s1 += Math.max(Math.max(p1, p2), Math.max(p3, p4));
            s2 += Math.min(Math.min(p1, p2), Math.min(p3, p4));
            if (max1 < 0.0) {
                l1 += max1 * max1;
            } else if (min1 > 0.0) {
                l1 += min1 * min1;
            }
            if (max2 < 0.0) {
                l2 += max2 * max2;
                continue;
            }
            if (!(min2 > 0.0)) continue;
            l2 += min2 * min2;
        }
        for (k = mindim; k < dim1; ++k) {
            min1 = v1.getMin(k);
            max1 = v1.getMax(k);
            if (max1 < 0.0) {
                l1 += max1 * max1;
                continue;
            }
            if (!(min1 > 0.0)) continue;
            l1 += min1 * min1;
        }
        for (k = mindim; k < dim2; ++k) {
            double min2 = v2.getMin(k);
            double max2 = v2.getMax(k);
            if (max2 < 0.0) {
                l2 += max2 * max2;
                continue;
            }
            if (!(min2 > 0.0)) continue;
            l2 += min2 * min2;
        }
        double cross = Math.max(Math.abs(s1), Math.abs(s2));
        double a = cross == 0.0 ? 0.0 : (l1 == 0.0 || l2 == 0.0 ? 1.0 : FastMath.sqrt(cross / l1 * (cross / l2)));
        return a < 1.0 ? a : 1.0;
    }

    public static double angle(NumberVector v1, NumberVector v2, NumberVector o) {
        double r1;
        double ok;
        int k;
        int dim1 = v1.getDimensionality();
        int dim2 = v2.getDimensionality();
        int dimo = o.getDimensionality();
        int mindim = dim1 <= dim2 ? dim1 : dim2;
        double cross = 0.0;
        double l1 = 0.0;
        double l2 = 0.0;
        for (k = 0; k < mindim; ++k) {
            ok = k < dimo ? o.doubleValue(k) : 0.0;
            r1 = v1.doubleValue(k) - ok;
            double r2 = v2.doubleValue(k) - ok;
            cross += r1 * r2;
            l1 += r1 * r1;
            l2 += r2 * r2;
        }
        for (k = mindim; k < dim1; ++k) {
            ok = k < dimo ? o.doubleValue(k) : 0.0;
            r1 = v1.doubleValue(k) - ok;
            l1 += r1 * r1;
        }
        for (k = mindim; k < dim2; ++k) {
            ok = k < dimo ? o.doubleValue(k) : 0.0;
            double r2 = v2.doubleValue(k) - ok;
            l2 += r2 * r2;
        }
        double a = cross == 0.0 ? 0.0 : (l1 == 0.0 || l2 == 0.0 ? 1.0 : FastMath.sqrt(cross / l1 * (cross / l2)));
        return a < 1.0 ? a : 1.0;
    }

    public static double dotDense(NumberVector v1, NumberVector v2) {
        int dim2;
        int dim1 = v1.getDimensionality();
        int mindim = dim1 <= (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double dot = 0.0;
        for (int k = 0; k < mindim; ++k) {
            dot += v1.doubleValue(k) * v2.doubleValue(k);
        }
        return dot;
    }

    public static double dotSparse(SparseNumberVector v1, SparseNumberVector v2) {
        double dot = 0.0;
        int i1 = v1.iter();
        int i2 = v2.iter();
        while (v1.iterValid(i1) && v2.iterValid(i2)) {
            int d2;
            int d1 = v1.iterDim(i1);
            if (d1 < (d2 = v2.iterDim(i2))) {
                i1 = v1.iterAdvance(i1);
                continue;
            }
            if (d2 < d1) {
                i2 = v2.iterAdvance(i2);
                continue;
            }
            dot += v1.iterDoubleValue(i1) * v2.iterDoubleValue(i2);
            i1 = v1.iterAdvance(i1);
            i2 = v2.iterAdvance(i2);
        }
        return dot;
    }

    public static double dotSparseDense(SparseNumberVector v1, NumberVector v2) {
        int d1;
        int dim2 = v2.getDimensionality();
        double dot = 0.0;
        int i1 = v1.iter();
        while (v1.iterValid(i1) && (d1 = v1.iterDim(i1)) < dim2) {
            dot += v1.iterDoubleValue(i1) * v2.doubleValue(d1);
            i1 = v1.iterAdvance(i1);
        }
        return dot;
    }

    public static double dot(NumberVector v1, NumberVector v2) {
        return v1 instanceof SparseNumberVector ? (v2 instanceof SparseNumberVector ? VectorUtil.dotSparse((SparseNumberVector)v1, (SparseNumberVector)v2) : VectorUtil.dotSparseDense((SparseNumberVector)v1, v2)) : (v2 instanceof SparseNumberVector ? VectorUtil.dotSparseDense((SparseNumberVector)v2, v1) : VectorUtil.dotDense(v1, v2));
    }

    public static double minDot(SpatialComparable v1, SpatialComparable v2) {
        int dim2;
        if (v1 instanceof NumberVector && v2 instanceof NumberVector) {
            return VectorUtil.dot((NumberVector)v1, (NumberVector)v2);
        }
        int dim1 = v1.getDimensionality();
        int mindim = dim1 <= (dim2 = v2.getDimensionality()) ? dim1 : dim2;
        double s1 = 0.0;
        double s2 = 0.0;
        for (int k = 0; k < mindim; ++k) {
            double min1 = v1.getMin(k);
            double max1 = v1.getMax(k);
            double min2 = v2.getMin(k);
            double max2 = v2.getMax(k);
            double p1 = min1 * min2;
            double p2 = min1 * max2;
            double p3 = max1 * min2;
            double p4 = max1 * max2;
            s1 += Math.max(Math.max(p1, p2), Math.max(p3, p4));
            s2 += Math.min(Math.min(p1, p2), Math.min(p3, p4));
        }
        return Math.max(Math.abs(s1), Math.abs(s2));
    }

    public static <V extends NumberVector> V project(V v, long[] selectedAttributes, NumberVector.Factory<V> factory) {
        int card = BitsUtil.cardinality(selectedAttributes);
        if (factory instanceof SparseNumberVector.Factory) {
            SparseNumberVector.Factory sfactory = (SparseNumberVector.Factory)factory;
            Int2DoubleOpenHashMap values = new Int2DoubleOpenHashMap(card, 0.8f);
            int d = BitsUtil.nextSetBit(selectedAttributes, 0);
            while (d >= 0) {
                if (v.doubleValue(d) != 0.0) {
                    values.put(d, v.doubleValue(d));
                }
                d = BitsUtil.nextSetBit(selectedAttributes, d + 1);
            }
            Object projectedVector = sfactory.newNumberVector(values, card);
            return projectedVector;
        }
        double[] newAttributes = new double[card];
        int i = 0;
        int d = BitsUtil.nextSetBit(selectedAttributes, 0);
        while (d >= 0) {
            newAttributes[i] = v.doubleValue(d);
            ++i;
            d = BitsUtil.nextSetBit(selectedAttributes, d + 1);
        }
        return factory.newNumberVector(newAttributes);
    }

    public static class SortVectorsBySingleDimension
    implements Comparator<NumberVector> {
        private int d;

        public SortVectorsBySingleDimension(int dim) {
            this.d = dim;
        }

        public SortVectorsBySingleDimension() {
        }

        public int getDimension() {
            return this.d;
        }

        public void setDimension(int d2) {
            this.d = d2;
        }

        @Override
        public int compare(NumberVector o1, NumberVector o2) {
            double v2;
            double v1 = o1.doubleValue(this.d);
            return v1 < (v2 = o2.doubleValue(this.d)) ? -1 : (v1 > v2 ? 1 : 0);
        }
    }

    public static class SortDBIDsBySingleDimension
    implements Comparator<DBIDRef> {
        private int d;
        private Relation<? extends NumberVector> data;

        public SortDBIDsBySingleDimension(Relation<? extends NumberVector> data, int dim) {
            this.data = data;
            this.d = dim;
        }

        public SortDBIDsBySingleDimension(Relation<? extends NumberVector> data) {
            this.data = data;
        }

        public int getDimension() {
            return this.d;
        }

        public void setDimension(int d2) {
            this.d = d2;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            double v2;
            double v1 = this.data.get(id1).doubleValue(this.d);
            return v1 < (v2 = this.data.get(id2).doubleValue(this.d)) ? -1 : (v1 > v2 ? 1 : 0);
        }
    }
}

