/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.model;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.Normalization;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import java.text.NumberFormat;
import java.util.Locale;
import net.jafama.FastMath;

public class CorrelationAnalysisSolution<V extends NumberVector>
implements TextWriteable,
Result,
Model {
    private static final double[] EMPTY_VECTOR = new double[0];
    private LinearEquationSystem linearEquationSystem;
    private NumberFormat nf;
    private int correlationDimensionality;
    private final double standardDeviation;
    private final double[][] weakEigenvectors;
    private final double[][] strongEigenvectors;
    private final double[][] similarityMatrix;
    private final double[] centroid;

    public CorrelationAnalysisSolution(LinearEquationSystem solution, Relation<V> db, double[][] strongEigenvectors, double[][] weakEigenvectors, double[][] similarityMatrix, double[] centroid) {
        this(solution, db, strongEigenvectors, weakEigenvectors, similarityMatrix, centroid, NumberFormat.getInstance(Locale.US));
    }

    public CorrelationAnalysisSolution(LinearEquationSystem solution, Relation<V> db, double[][] strongEigenvectors, double[][] weakEigenvectors, double[][] similarityMatrix, double[] centroid, NumberFormat nf) {
        this.linearEquationSystem = solution;
        this.correlationDimensionality = strongEigenvectors[0].length;
        this.strongEigenvectors = strongEigenvectors;
        this.weakEigenvectors = weakEigenvectors;
        this.similarityMatrix = similarityMatrix;
        this.centroid = centroid;
        this.nf = nf;
        double variance = 0.0;
        DBIDs ids = db.getDBIDs();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            variance += this.squaredDistance((NumberVector)db.get(iter));
            iter.advance();
        }
        this.standardDeviation = FastMath.sqrt(variance / (double)ids.size());
    }

    public LinearEquationSystem getNormalizedLinearEquationSystem(Normalization<?> normalization) throws NonNumericFeaturesException {
        if (normalization != null) {
            LinearEquationSystem lq = normalization.transform(this.linearEquationSystem);
            lq.solveByTotalPivotSearch();
            return lq;
        }
        return this.linearEquationSystem;
    }

    public int getCorrelationDimensionality() {
        return this.correlationDimensionality;
    }

    public double squaredDistance(V p) {
        double[] p_minus_a = VMath.minusEquals(p.toArray(), this.centroid);
        return VMath.squareSum(VMath.minusEquals(p_minus_a, VMath.times(this.strongEigenvectors, VMath.transposeTimes(this.strongEigenvectors, p_minus_a))));
    }

    public double[] errorVector(V p) {
        return this.weakEigenvectors.length > 0 ? VMath.times(this.weakEigenvectors, VMath.transposeTimes(this.weakEigenvectors, VMath.minusEquals(p.toArray(), this.centroid))) : EMPTY_VECTOR;
    }

    public double[] dataVector(V p) {
        return this.strongEigenvectors.length > 0 ? VMath.times(this.strongEigenvectors, VMath.transposeTimes(this.strongEigenvectors, VMath.minusEquals(p.toArray(), this.centroid))) : EMPTY_VECTOR;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double[][] getStrongEigenvectors() {
        return this.strongEigenvectors;
    }

    public double[][] getWeakEigenvectors() {
        return this.weakEigenvectors;
    }

    public double[][] getSimilarityMatrix() {
        return this.similarityMatrix;
    }

    public double[] getCentroid() {
        return this.centroid;
    }

    @Override
    public void writeToText(TextWriterStream out, String label) {
        if (label != null) {
            out.commentPrintLn(label);
        }
        out.commentPrintLn("Model class: " + this.getClass().getName());
        try {
            if (this.getNormalizedLinearEquationSystem(null) != null) {
                LinearEquationSystem lq = this.getNormalizedLinearEquationSystem(null);
                out.commentPrint("Linear Equation System: ");
                out.commentPrintLn(lq.equationsToString(this.nf));
            }
        }
        catch (NonNumericFeaturesException e) {
            LoggingUtil.exception(e);
        }
    }

    @Override
    public String getLongName() {
        return "Correlation Analysis Solution";
    }

    @Override
    public String getShortName() {
        return "correlationanalysissolution";
    }
}

