/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.model;

import de.lmu.ifi.dbs.elki.data.model.SimplePrototypeModel;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;

public class CorrelationModel
extends SimplePrototypeModel<double[]> {
    private PCAFilteredResult pcaresult;

    public CorrelationModel(PCAFilteredResult pcaresult, double[] centroid) {
        super(centroid);
        this.pcaresult = pcaresult;
    }

    public PCAFilteredResult getPCAResult() {
        return this.pcaresult;
    }

    public void setPCAResult(PCAFilteredResult pcaresult) {
        this.pcaresult = pcaresult;
    }

    @Override
    public void writeToText(TextWriterStream out, String label) {
        if (label != null) {
            out.commentPrintLn(label);
        }
        out.commentPrintLn("Model class: " + this.getClass().getName());
        out.commentPrintLn("Centroid: " + ((double[])this.getPrototype()).toString());
        out.commentPrintLn("Strong Eigenvectors:");
        String strong = FormatUtil.format(this.getPCAResult().getStrongEigenvectors());
        while (strong.endsWith("\n")) {
            strong = strong.substring(0, strong.length() - 1);
        }
        out.commentPrintLn(strong);
        out.commentPrintLn("Weak Eigenvectors:");
        String weak = FormatUtil.format(this.getPCAResult().getWeakEigenvectors());
        while (weak.endsWith("\n")) {
            weak = weak.substring(0, weak.length() - 1);
        }
        out.commentPrintLn(weak);
        out.commentPrintLn("Eigenvalues: " + FormatUtil.format(this.getPCAResult().getEigenvalues()));
    }
}

