/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.model;

import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;

public class EMModel
extends MeanModel {
    private double[][] covarianceMatrix;

    public EMModel(double[] mean, double[][] covarianceMatrix) {
        super(mean);
        this.covarianceMatrix = covarianceMatrix;
    }

    @Override
    public void writeToText(TextWriterStream out, String label) {
        super.writeToText(out, label);
        out.commentPrintLn("Covariance Matrix: " + FormatUtil.format(this.covarianceMatrix, FormatUtil.NF16));
    }

    public double[][] getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public void setCovarianceMatrix(double[][] covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.prototypeToString() + "," + FormatUtil.format(this.covarianceMatrix, FormatUtil.NF8) + "]";
    }
}

