/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.model;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.model.PrototypeModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberVectorAdapter;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static <V extends NumberVector> V getPrototype(Model model, Relation<? extends V> relation, NumberVector.Factory<V> factory) {
        if (model instanceof MeanModel) {
            double[] p = ((MeanModel)model).getMean();
            return factory.newNumberVector(p);
        }
        if (model instanceof MedoidModel) {
            NumberVector p = (NumberVector)relation.get(((MedoidModel)model).getMedoid());
            if (factory.getRestrictionClass().isInstance(p)) {
                return (V)p;
            }
            return factory.newNumberVector(p, NumberVectorAdapter.STATIC);
        }
        if (model instanceof PrototypeModel) {
            Object p = ((PrototypeModel)model).getPrototype();
            if (factory.getRestrictionClass().isInstance(p)) {
                return (V)((NumberVector)p);
            }
            if (p instanceof NumberVector) {
                return factory.newNumberVector((NumberVector)p, NumberVectorAdapter.STATIC);
            }
            return null;
        }
        return null;
    }

    public static NumberVector getPrototype(Model model, Relation<? extends NumberVector> relation) {
        if (model instanceof MeanModel) {
            return DoubleVector.wrap(((MeanModel)model).getMean());
        }
        if (model instanceof MedoidModel) {
            return relation.get(((MedoidModel)model).getMedoid());
        }
        if (model instanceof PrototypeModel) {
            Object p = ((PrototypeModel)model).getPrototype();
            if (p instanceof NumberVector) {
                return (NumberVector)p;
            }
            return null;
        }
        return null;
    }

    public static <V extends NumberVector> V getPrototypeOrCentroid(Model model, Relation<? extends V> relation, DBIDs ids, NumberVector.Factory<V> factory) {
        assert (ids.size() > 0);
        V v = ModelUtil.getPrototype(model, relation, factory);
        return v != null ? v : factory.newNumberVector(Centroid.make(relation, ids));
    }

    public static NumberVector getPrototypeOrCentroid(Model model, Relation<? extends NumberVector> relation, DBIDs ids) {
        assert (ids.size() > 0);
        NumberVector v = ModelUtil.getPrototype(model, relation);
        return v != null ? v : Centroid.make(relation, ids);
    }
}

