/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.FeatureVectorAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberVectorAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.SubsetArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;

public class FeatureSelection<V extends FeatureVector<F>, F>
implements Projection<V, V> {
    private int mindim;
    private FeatureVector.Factory<V, F> factory;
    private int dimensionality;
    protected ArrayAdapter<F, V> adapter;

    public FeatureSelection(int[] dims) {
        this.adapter = new SubsetArrayAdapter<F, V>(FeatureSelection.getAdapter(this.factory), dims);
        this.dimensionality = dims.length;
        int mind = 0;
        for (int dim : dims) {
            mind = Math.max(mind, dim + 1);
        }
        this.mindim = mind;
    }

    @Override
    public void initialize(SimpleTypeInformation<? extends V> in) {
        VectorFieldTypeInformation vin = (VectorFieldTypeInformation)in;
        this.factory = vin.getFactory();
        if (vin.getDimensionality() < this.mindim) {
            throw new AbortException("Data does not have enough dimensions for this projection!");
        }
    }

    @Override
    public V project(V data) {
        return this.factory.newFeatureVector(data, this.adapter);
    }

    private static <V extends FeatureVector<F>, F> ArrayAdapter<F, ? super V> getAdapter(FeatureVector.Factory<V, F> factory) {
        if (factory instanceof NumberVector.Factory) {
            return NumberVectorAdapter.STATIC;
        }
        return FeatureVectorAdapter.STATIC;
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation<V>(this.factory, this.dimensionality);
    }

    @Override
    public TypeInformation getInputDataTypeInformation() {
        Class<V> cls = this.factory.getRestrictionClass();
        return VectorTypeInformation.typeRequest(cls, this.mindim, Integer.MAX_VALUE);
    }

    public static class Parameterizer<V extends FeatureVector<F>, F>
    extends AbstractParameterizer {
        public static final OptionID SELECTED_ATTRIBUTES_ID = new OptionID("projectionfilter.selectedattributes", "a comma separated array of integer values d_i, where 0 <= d_i < the dimensionality of the feature space specifying the dimensions to be considered for projection. If this parameter is not set, no dimensions will be considered, i.e. the projection is a zero-dimensional feature space");
        int[] dims = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntListParameter selectedAttributesP = (IntListParameter)new IntListParameter(SELECTED_ATTRIBUTES_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST);
            if (config.grab(selectedAttributesP)) {
                this.dims = (int[])((int[])selectedAttributesP.getValue()).clone();
            }
        }

        @Override
        protected FeatureSelection<V, F> makeInstance() {
            return new FeatureSelection(this.dims);
        }
    }
}

