/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LngLatToECEFProjection<V extends NumberVector>
implements Projection<V, V> {
    EarthModel model;
    private NumberVector.Factory<V> factory;

    public LngLatToECEFProjection(EarthModel model) {
        this.model = model;
    }

    @Override
    public void initialize(SimpleTypeInformation<? extends V> in) {
        VectorFieldTypeInformation vin = (VectorFieldTypeInformation)in;
        this.factory = (NumberVector.Factory)vin.getFactory();
    }

    @Override
    public V project(V data) {
        return this.factory.newNumberVector(this.model.latLngDegToECEF(data.doubleValue(1), data.doubleValue(0)));
    }

    @Override
    public SimpleTypeInformation<? super V> getInputDataTypeInformation() {
        return TypeUtil.NUMBER_VECTOR_FIELD_2D;
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation(this.factory, 3, 3, this.factory.getDefaultSerializer());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        EarthModel model;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter modelP = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
            if (config.grab(modelP)) {
                this.model = (EarthModel)modelP.instantiateClass(config);
            }
        }

        @Override
        protected LngLatToECEFProjection<NumberVector> makeInstance() {
            return new LngLatToECEFProjection<NumberVector>(this.model);
        }
    }
}

