/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.FeatureSelection;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;
import java.util.BitSet;

public class NumericalFeatureSelection<V extends NumberVector>
implements Projection<V, V> {
    private int mindim;
    private NumberVector.Factory<V> factory;
    private int[] dims;

    public NumericalFeatureSelection(int[] dims) {
        this.dims = dims;
        int mind = 0;
        for (int i : dims) {
            mind = i > mind ? i : mind;
        }
        this.mindim = mind + 1;
    }

    public NumericalFeatureSelection(BitSet bits) {
        int card = bits.cardinality();
        this.dims = new int[card];
        int mind = 0;
        int i = bits.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            this.dims[j] = i;
            mind = i > mind ? i : mind;
            i = bits.nextSetBit(i + 1);
            ++j;
        }
        this.mindim = mind + 1;
    }

    @Override
    public void initialize(SimpleTypeInformation<? extends V> in) {
        VectorFieldTypeInformation vin = (VectorFieldTypeInformation)in;
        this.factory = (NumberVector.Factory)vin.getFactory();
        if (vin.getDimensionality() < this.mindim) {
            throw new AbortException("Data does not have enough dimensions for this projection!");
        }
    }

    @Override
    public V project(V data) {
        double[] dbl = new double[this.dims.length];
        for (int i = 0; i < this.dims.length; ++i) {
            dbl[i] = data.doubleValue(this.dims[i]);
        }
        return this.factory.newNumberVector(dbl);
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation(this.factory, this.dims.length);
    }

    @Override
    public TypeInformation getInputDataTypeInformation() {
        return VectorTypeInformation.typeRequest(NumberVector.class, this.mindim, Integer.MAX_VALUE);
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        int[] dims;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntListParameter selectedAttributesP = (IntListParameter)new IntListParameter(FeatureSelection.Parameterizer.SELECTED_ATTRIBUTES_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST);
            if (config.grab(selectedAttributesP)) {
                this.dims = (int[])selectedAttributesP.getValue();
            }
        }

        @Override
        protected NumericalFeatureSelection<V> makeInstance() {
            return new NumericalFeatureSelection(this.dims);
        }
    }
}

