/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.projection.random.AchlioptasRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class RandomProjection<V extends NumberVector>
implements Projection<V, V> {
    private static final Logging LOG = Logging.getLogger(RandomProjection.class);
    private NumberVector.Factory<V> factory = null;
    private int dimensionality;
    private RandomProjectionFamily.Projection projection = null;
    private RandomProjectionFamily family;

    public RandomProjection(int dimensionality, RandomProjectionFamily family) {
        this.dimensionality = dimensionality;
        this.family = family;
    }

    @Override
    public void initialize(SimpleTypeInformation<? extends V> in) {
        VectorFieldTypeInformation vin = (VectorFieldTypeInformation)in;
        this.factory = (NumberVector.Factory)vin.getFactory();
        int inputdim = vin.getDimensionality();
        this.projection = this.family.generateProjection(inputdim, this.dimensionality);
        if (LOG.isDebugging()) {
            LOG.debug(this.projection.toString());
        }
    }

    @Override
    public V project(V data) {
        return this.factory.newNumberVector(this.projection.project((NumberVector)data));
    }

    @Override
    public TypeInformation getInputDataTypeInformation() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation(this.factory, this.dimensionality);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FAMILY_ID = new OptionID("randomproj.family", "Projection family to use.");
        public static final OptionID DIMENSIONALITY_ID = new OptionID("randomproj.dimensionality", "Amount of dimensions to project to.");
        private int dimensionality;
        private RandomProjectionFamily family;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter dimP;
            super.makeOptions(config);
            ObjectParameter familyP = new ObjectParameter(FAMILY_ID, RandomProjectionFamily.class);
            familyP.setDefaultValue(AchlioptasRandomProjectionFamily.class);
            if (config.grab(familyP)) {
                this.family = (RandomProjectionFamily)familyP.instantiateClass(config);
            }
            if (config.grab(dimP = (IntParameter)new IntParameter(DIMENSIONALITY_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.dimensionality = dimP.intValue();
            }
        }

        @Override
        protected RandomProjection<NumberVector> makeInstance() {
            return new RandomProjection<NumberVector>(this.dimensionality, this.family);
        }
    }
}

