/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection.random;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Arrays;
import java.util.Random;

public abstract class AbstractRandomProjectionFamily
implements RandomProjectionFamily {
    protected Random random;

    public AbstractRandomProjectionFamily(RandomFactory random) {
        this.random = random.getSingleThreadedRandom();
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("randomproj.random", "Random generator seed.");
        protected RandomFactory random;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            RandomParameter rndP = new RandomParameter(RANDOM_ID);
            if (config.grab(rndP)) {
                this.random = (RandomFactory)rndP.getValue();
            }
        }
    }

    public static class MatrixProjection
    implements RandomProjectionFamily.Projection {
        double[][] matrix;
        private double[] buf;

        public MatrixProjection(double[][] matrix) {
            this.matrix = matrix;
            this.buf = new double[matrix.length];
        }

        @Override
        public double[] project(NumberVector in) {
            return this.project(in, new double[this.matrix.length]);
        }

        @Override
        public double[] project(NumberVector in, double[] ret) {
            if (in instanceof SparseNumberVector) {
                return this.projectSparse((SparseNumberVector)in, ret);
            }
            int dim = Math.min(this.buf.length, in.getDimensionality());
            assert (ret.length >= this.matrix.length) : "Output buffer too small!";
            for (int i = 0; i < dim; ++i) {
                this.buf[i] = in.doubleValue(i);
            }
            for (int o = 0; o < this.matrix.length; ++o) {
                double[] row = this.matrix[o];
                double v = 0.0;
                for (int i = 0; i < dim; ++i) {
                    v += row[i] * this.buf[i];
                }
                ret[o] = v;
            }
            for (int d = this.matrix.length; d < ret.length; ++d) {
                ret[d] = 0.0;
            }
            return ret;
        }

        private double[] projectSparse(SparseNumberVector in, double[] ret) {
            Arrays.fill(ret, 0.0);
            int iter = in.iter();
            while (in.iterValid(iter)) {
                int i = in.iterDim(iter);
                double val = in.iterDoubleValue(iter);
                for (int o = 0; o < ret.length; ++o) {
                    int n = o;
                    ret[n] = ret[n] + val * this.matrix[o][i];
                }
                iter = in.iterAdvance(iter);
            }
            return ret;
        }

        @Override
        public int getOutputDimensionality() {
            return this.matrix.length;
        }
    }
}

