/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection.random;

import de.lmu.ifi.dbs.elki.data.projection.random.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Reference(title="Database-friendly random projections: Johnson-Lindenstrauss with binary coins", authors="D. Achlioptas", booktitle="Proc. 20th ACM SIGMOD-SIGACT-SIGART symposium on Principles of database systems", url="https://doi.org/10.1145/375551.375608", bibkey="DBLP:conf/pods/Achlioptas01")
@Alias(value={"de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.AchlioptasRandomProjectionFamily"})
public class AchlioptasRandomProjectionFamily
extends AbstractRandomProjectionFamily {
    private double sparsity;

    public AchlioptasRandomProjectionFamily(double sparsity, RandomFactory random) {
        super(random);
        this.sparsity = sparsity;
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int idim, int odim) {
        double pPos = 0.5 / this.sparsity;
        double pNeg = pPos + pPos;
        double baseValuePart = Math.sqrt(this.sparsity);
        double[][] matrix = new double[odim][idim];
        for (int i = 0; i < odim; ++i) {
            double[] row = matrix[i];
            for (int j = 0; j < idim; ++j) {
                double r = this.random.nextDouble();
                row[j] = r < pPos ? baseValuePart : (r < pNeg ? -baseValuePart : 0.0);
            }
        }
        return new AbstractRandomProjectionFamily.MatrixProjection(matrix);
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        public static final OptionID SPARSITY_ID = new OptionID("achlioptas.sparsity", "Frequency of zeros in the projection matrix.");
        private double sparsity = 3.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter sparsP = (DoubleParameter)((DoubleParameter)new DoubleParameter(SPARSITY_ID).setDefaultValue((Object)3.0)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_DOUBLE);
            if (config.grab(sparsP)) {
                this.sparsity = sparsP.doubleValue();
            }
        }

        @Override
        protected AchlioptasRandomProjectionFamily makeInstance() {
            return new AchlioptasRandomProjectionFamily(this.sparsity, this.random);
        }
    }
}

