/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection.random;

import de.lmu.ifi.dbs.elki.data.projection.random.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import net.jafama.FastMath;

@Reference(authors="M. Datar, N. Immorlica, P. Indyk, V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th Annual Symposium on Computational Geometry", url="https://doi.org/10.1145/997817.997857", bibkey="DBLP:conf/compgeom/DatarIIM04")
@Alias(value={"de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.CauchyRandomProjectionFamily"})
public class CauchyRandomProjectionFamily
extends AbstractRandomProjectionFamily {
    public CauchyRandomProjectionFamily(RandomFactory random) {
        super(random);
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int idim, int odim) {
        double[][] matrix = new double[odim][idim];
        for (int i = 0; i < odim; ++i) {
            double[] row = matrix[i];
            for (int j = 0; j < idim; ++j) {
                row[j] = FastMath.tan(Math.PI * (this.random.nextDouble() - 0.5));
            }
        }
        return new AbstractRandomProjectionFamily.MatrixProjection(matrix);
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        @Override
        protected CauchyRandomProjectionFamily makeInstance() {
            return new CauchyRandomProjectionFamily(this.random);
        }
    }
}

