/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection.random;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.random.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Arrays;
import java.util.Random;

@Reference(authors="L. Breiman", title="Bagging predictors", booktitle="Machine learning 24.2", url="https://doi.org/10.1007/BF00058655", bibkey="DBLP:journals/ml/Breiman96b")
@Alias(value={"de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomSubsetProjectionFamily"})
public class RandomSubsetProjectionFamily
extends AbstractRandomProjectionFamily {
    public RandomSubsetProjectionFamily(RandomFactory random) {
        super(random);
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int idim, int odim) {
        int[] dims;
        if (odim < idim) {
            dims = Arrays.copyOf(RandomSubsetProjectionFamily.randomPermutation(RandomSubsetProjectionFamily.sequence(idim), this.random), odim);
        } else if (odim == idim) {
            dims = RandomSubsetProjectionFamily.randomPermutation(RandomSubsetProjectionFamily.sequence(idim), this.random);
        } else {
            int mdim = ((odim - 1) / idim + 1) * idim;
            dims = new int[mdim];
            int j = 0;
            for (int i = 0; i < mdim; ++i) {
                dims[i] = j++;
                j = j == idim ? 0 : j;
            }
            dims = Arrays.copyOf(RandomSubsetProjectionFamily.randomPermutation(dims, this.random), odim);
        }
        return new SubsetProjection(dims);
    }

    public static int[] randomPermutation(int[] out, Random random) {
        for (int i = out.length - 1; i > 0; --i) {
            int ri = random.nextInt(i + 1);
            int tmp = out[ri];
            out[ri] = out[i];
            out[i] = tmp;
        }
        return out;
    }

    private static int[] sequence(int e) {
        int[] a = new int[e];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        return a;
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        @Override
        protected RandomSubsetProjectionFamily makeInstance() {
            return new RandomSubsetProjectionFamily(this.random);
        }
    }

    public static class SubsetProjection
    implements RandomProjectionFamily.Projection {
        private int[] dims;

        public SubsetProjection(int[] dims) {
            this.dims = dims;
        }

        @Override
        public double[] project(NumberVector in) {
            return this.project(in, new double[this.dims.length]);
        }

        @Override
        public double[] project(NumberVector in, double[] buffer) {
            for (int i = 0; i < this.dims.length; ++i) {
                buffer[i] = in.doubleValue(this.dims[i]);
            }
            return buffer;
        }

        @Override
        public int getOutputDimensionality() {
            return this.dims.length;
        }
    }
}

