/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection.random;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.projection.random.AbstractRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="M. Henzinger", title="Finding near-duplicate web pages: a large-scale evaluation of algorithms", booktitle="Proc. 29th ACM Conf. Research and Development in Information Retrieval (SIGIR 2006)", url="https://doi.org/10.1145/1148170.1148222", bibkey="DBLP:conf/sigir/Henzinger06")
@Alias(value={"de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.SimplifiedRandomHyperplaneProjectionFamily"})
public class SimplifiedRandomHyperplaneProjectionFamily
implements RandomProjectionFamily {
    protected Random random;

    public SimplifiedRandomHyperplaneProjectionFamily(RandomFactory random) {
        this.random = random.getSingleThreadedRandom();
    }

    @Override
    public RandomProjectionFamily.Projection generateProjection(int dim, int k) {
        return new SignedProjection(dim, k, this.random);
    }

    public static class Parameterizer
    extends AbstractRandomProjectionFamily.Parameterizer {
        @Override
        protected SimplifiedRandomHyperplaneProjectionFamily makeInstance() {
            return new SimplifiedRandomHyperplaneProjectionFamily(this.random);
        }
    }

    private static class SignedProjection
    implements RandomProjectionFamily.Projection {
        boolean[][] mat;
        private int k;
        private double[] buf;

        public SignedProjection(int dim, int k, Random random) {
            this.mat = new boolean[dim][k];
            for (int i = 0; i < dim; ++i) {
                boolean[] row = this.mat[i];
                for (int j = 0; j < k; ++j) {
                    row[j] = random.nextBoolean();
                }
            }
            this.k = k;
            this.buf = new double[dim];
        }

        @Override
        public double[] project(NumberVector in) {
            return this.project(in, new double[this.k]);
        }

        @Override
        public double[] project(NumberVector vec, double[] ret) {
            if (!(vec instanceof SparseNumberVector)) {
                return this.projectDense(vec, ret);
            }
            SparseNumberVector in = (SparseNumberVector)vec;
            int k = this.k;
            int iter = in.iter();
            while (in.iterValid(iter)) {
                int i = in.iterDim(iter);
                double x = in.iterDoubleValue(iter);
                boolean[] row = this.mat[i];
                for (int o = 0; o < k; ++o) {
                    if (row[o]) {
                        int n = o;
                        ret[n] = ret[n] + x;
                        continue;
                    }
                    int n = o;
                    ret[n] = ret[n] - x;
                }
                iter = in.iterAdvance(iter);
            }
            return ret;
        }

        private double[] projectDense(NumberVector in, double[] ret) {
            int k = this.k;
            double dim = Math.min(this.buf.length, in.getDimensionality());
            int i = 0;
            while ((double)i < dim) {
                boolean[] row = this.mat[i];
                double vali = in.doubleValue(i);
                for (int o = 0; o < k; ++o) {
                    if (row[o]) {
                        int n = o;
                        ret[n] = ret[n] + vali;
                        continue;
                    }
                    int n = o;
                    ret[n] = ret[n] - vali;
                }
                ++i;
            }
            return ret;
        }

        @Override
        public int getOutputDimensionality() {
            return this.k;
        }
    }
}

