/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.spatial;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class Polygon
implements SpatialComparable {
    private List<double[]> points;
    private double[] min = null;
    private double[] max = null;

    public Polygon(List<double[]> points) {
        assert (points instanceof RandomAccess);
        this.points = points;
        if (!points.isEmpty()) {
            Iterator<double[]> iter = points.iterator();
            double[] first = iter.next();
            int dim = first.length;
            this.min = (double[])first.clone();
            this.max = (double[])first.clone();
            while (iter.hasNext()) {
                double[] next = iter.next();
                for (int i = 0; i < dim; ++i) {
                    double cur = next[i];
                    this.min[i] = Math.min(this.min[i], cur);
                    this.max[i] = Math.max(this.max[i], cur);
                }
            }
        }
    }

    public Polygon(List<double[]> points, double minx, double maxx, double miny, double maxy) {
        assert (points instanceof RandomAccess);
        this.points = points;
        this.min = new double[]{minx, miny};
        this.max = new double[]{maxx, maxy};
    }

    public ArrayListIter<double[]> iter() {
        return new ArrayListIter<double[]>(this.points);
    }

    public StringBuilder appendToBuffer(StringBuilder buf) {
        Iterator<double[]> iter = this.points.iterator();
        while (iter.hasNext()) {
            double[] data = iter.next();
            for (int i = 0; i < data.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(data[i]);
            }
            if (!iter.hasNext()) continue;
            buf.append(' ');
        }
        return buf;
    }

    public String toString() {
        return this.appendToBuffer(new StringBuilder(this.points.size() * 20)).toString();
    }

    public int size() {
        return this.points.size();
    }

    public double[] get(int idx) {
        return this.points.get(idx);
    }

    @Override
    public int getDimensionality() {
        return this.min.length;
    }

    @Override
    public double getMin(int dimension) {
        return this.min[dimension];
    }

    @Override
    public double getMax(int dimension) {
        return this.max[dimension];
    }

    public int testClockwise() {
        if (this.points.size() < 3) {
            return 0;
        }
        int size = this.points.size();
        int c = 0;
        for (int i = 0; i < size; ++i) {
            double dxkj;
            double dyji;
            double dykj;
            int j = (i + 1) % size;
            int k = (i + 2) % size;
            double dxji = this.points.get(j)[0] - this.points.get(i)[0];
            double z = dxji * (dykj = this.points.get(k)[1] - this.points.get(j)[1]) - (dyji = this.points.get(j)[1] - this.points.get(i)[1]) * (dxkj = this.points.get(k)[0] - this.points.get(j)[0]);
            if (z < 0.0) {
                --c;
                continue;
            }
            if (!(z > 0.0)) continue;
            ++c;
        }
        return c > 0 ? -1 : (c < 0 ? 1 : 0);
    }

    public boolean intersects2DIncomplete(Polygon other) {
        assert (this.getDimensionality() == 2);
        assert (other.getDimensionality() == 2);
        for (double[] v : this.points) {
            if (!other.containsPoint2D(v)) continue;
            return true;
        }
        for (double[] v : other.points) {
            if (!this.containsPoint2D(v)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint2D(double[] v) {
        assert (v.length == 2);
        double testx = v[0];
        double testy = v[1];
        boolean c = false;
        Iterator<double[]> it = this.points.iterator();
        double[] pre = this.points.get(this.points.size() - 1);
        while (it.hasNext()) {
            double prey;
            double[] cur = it.next();
            double curx = cur[0];
            double cury = cur[1];
            double prex = pre[0];
            if (cury > testy != (prey = pre[1]) > testy && testx < (prex - curx) * (testy - cury) / (prey - cury) + curx) {
                c = !c;
            }
            pre = cur;
        }
        return c;
    }

    public double areaShoelace() {
        if (this.points.size() <= 1) {
            return 0.0;
        }
        double agg = 0.0;
        Iterator<double[]> iter = this.points.iterator();
        double[] first = iter.next();
        double[] cur = null;
        double px = first[0];
        double py = first[1];
        while (iter.hasNext()) {
            cur = iter.next();
            double x = cur[0];
            double y = cur[1];
            agg += x * py - y * px;
            px = x;
            py = y;
        }
        return Math.abs((agg += first[0] * py - first[1] * px) * 0.5);
    }
}

