/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.spatial;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class PolygonsObject
implements SpatialComparable {
    public static final PolygonsObject PROTOTYPE = new PolygonsObject(null);
    private Collection<Polygon> polygons;

    public PolygonsObject(Collection<Polygon> polygons) {
        this.polygons = polygons;
        if (this.polygons == null) {
            this.polygons = Collections.emptyList();
        }
    }

    public Collection<Polygon> getPolygons() {
        return Collections.unmodifiableCollection(this.polygons);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.appendToBuffer(buf);
        return buf.toString();
    }

    public void appendToBuffer(StringBuilder buf) {
        Iterator<Polygon> iter = this.polygons.iterator();
        while (iter.hasNext()) {
            Polygon poly = iter.next();
            poly.appendToBuffer(buf);
            if (!iter.hasNext()) continue;
            buf.append(" -- ");
        }
    }

    @Override
    public int getDimensionality() {
        assert (!this.polygons.isEmpty());
        return this.polygons.iterator().next().getDimensionality();
    }

    @Override
    public double getMin(int dimension) {
        double min = Double.MAX_VALUE;
        for (Polygon p : this.polygons) {
            min = Math.min(min, p.getMin(dimension));
        }
        return min;
    }

    @Override
    public double getMax(int dimension) {
        double max = Double.MIN_VALUE;
        for (Polygon p : this.polygons) {
            max = Math.max(max, p.getMin(dimension));
        }
        return max;
    }
}

