/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.spatial;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;

public final class SpatialUtil {
    private SpatialUtil() {
    }

    public static int assertSameDimensionality(SpatialComparable box1, SpatialComparable box2) {
        int dim = box1.getDimensionality();
        if (dim != box2.getDimensionality()) {
            throw new IllegalArgumentException("The spatial objects do not have the same dimensionality!");
        }
        return dim;
    }

    public static double[] getMin(SpatialComparable box) {
        int dim = box.getDimensionality();
        double[] min = new double[dim];
        for (int i = 0; i < dim; ++i) {
            min[i] = box.getMin(i);
        }
        return min;
    }

    public static double[] getMax(SpatialComparable box) {
        int dim = box.getDimensionality();
        double[] max = new double[dim];
        for (int i = 0; i < dim; ++i) {
            max[i] = box.getMax(i);
        }
        return max;
    }

    public static boolean intersects(SpatialComparable box1, SpatialComparable box2) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        for (int i = 0; i < dim; ++i) {
            if (!(box2.getMax(i) < box1.getMin(i)) && !(box1.getMax(i) < box2.getMin(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(SpatialComparable box1, SpatialComparable box2) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        for (int i = 0; i < dim; ++i) {
            if (!(box2.getMin(i) < box1.getMin(i)) && !(box1.getMax(i) < box2.getMax(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(SpatialComparable box, double[] point) {
        int dim = box.getDimensionality();
        if (dim != point.length) {
            throw new IllegalArgumentException("This HyperBoundingBox and the given point need same dimensionality");
        }
        for (int i = 0; i < dim; ++i) {
            if (!(box.getMin(i) > point[i]) && !(box.getMax(i) < point[i])) continue;
            return false;
        }
        return true;
    }

    public static double volume(SpatialComparable box) {
        int dim = box.getDimensionality();
        double vol = 1.0;
        for (int i = 0; i < dim; ++i) {
            double delta = box.getMax(i) - box.getMin(i);
            if (delta == 0.0) {
                return 0.0;
            }
            vol *= delta;
        }
        return vol;
    }

    public static double volumeUnion(SpatialComparable box1, SpatialComparable box2) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        double volume = 1.0;
        for (int i = 0; i < dim; ++i) {
            double min = Math.min(box1.getMin(i), box2.getMin(i));
            double max = Math.max(box1.getMax(i), box2.getMax(i));
            volume *= max - min;
        }
        return volume;
    }

    public static double volumeScaled(SpatialComparable box, double scale) {
        int dim = box.getDimensionality();
        double vol = 1.0;
        for (int i = 0; i < dim; ++i) {
            double delta = box.getMax(i) - box.getMin(i);
            if (delta == 0.0) {
                return 0.0;
            }
            vol *= delta * scale;
        }
        return vol;
    }

    public static double volumeUnionScaled(SpatialComparable box1, SpatialComparable box2, double scale) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        double volume = 1.0;
        for (int i = 0; i < dim; ++i) {
            double min = Math.min(box1.getMin(i), box2.getMin(i));
            double max = Math.max(box1.getMax(i), box2.getMax(i));
            volume *= (max - min) * scale;
        }
        return volume;
    }

    public static double enlargement(SpatialComparable exist, SpatialComparable addit) {
        int dim = SpatialUtil.assertSameDimensionality(exist, addit);
        double v1 = 1.0;
        double v2 = 1.0;
        for (int i = 0; i < dim; ++i) {
            double emin = exist.getMin(i);
            double emax = exist.getMax(i);
            double amin = addit.getMin(i);
            double amax = addit.getMax(i);
            double min = Math.min(emin, amin);
            double max = Math.max(emax, amax);
            v1 *= max - min;
            v2 *= emax - emin;
        }
        return v2 - v1;
    }

    public static double enlargementScaled(SpatialComparable exist, SpatialComparable addit, double scale) {
        int dim = SpatialUtil.assertSameDimensionality(exist, addit);
        double v1 = 1.0;
        double v2 = 1.0;
        for (int i = 0; i < dim; ++i) {
            double emin = exist.getMin(i);
            double emax = exist.getMax(i);
            double amin = addit.getMin(i);
            double amax = addit.getMax(i);
            double min = Math.min(emin, amin);
            double max = Math.max(emax, amax);
            v1 *= (max - min) * scale;
            v2 *= (emax - emin) * scale;
        }
        return v2 - v1;
    }

    public static double perimeter(SpatialComparable box) {
        int dim = box.getDimensionality();
        double perimeter = 0.0;
        for (int i = 0; i < dim; ++i) {
            perimeter += box.getMax(i) - box.getMin(i);
        }
        return perimeter;
    }

    public static double overlap(SpatialComparable box1, SpatialComparable box2) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        double overlap = 1.0;
        for (int i = 0; i < dim; ++i) {
            double omin;
            double omax = Math.min(box1.getMax(i), box2.getMax(i));
            if (omax <= (omin = Math.max(box1.getMin(i), box2.getMin(i)))) {
                return 0.0;
            }
            overlap *= omax - omin;
        }
        return overlap;
    }

    public static double relativeOverlap(SpatialComparable box1, SpatialComparable box2) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        double overlap = 1.0;
        double vol1 = 1.0;
        double vol2 = 1.0;
        for (int i = 0; i < dim; ++i) {
            double omin;
            double box1min = box1.getMin(i);
            double box1max = box1.getMax(i);
            double box2min = box2.getMin(i);
            double box2max = box2.getMax(i);
            double omax = Math.min(box1max, box2max);
            if (omax <= (omin = Math.max(box1min, box2min))) {
                return 0.0;
            }
            overlap *= omax - omin;
            vol1 *= box1max - box1min;
            vol2 *= box2max - box2min;
        }
        return overlap / (vol1 + vol2);
    }

    public static ModifiableHyperBoundingBox union(SpatialComparable box1, SpatialComparable box2) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        double[] min = new double[dim];
        double[] max = new double[dim];
        for (int i = 0; i < dim; ++i) {
            min[i] = Math.min(box1.getMin(i), box2.getMin(i));
            max[i] = Math.max(box1.getMax(i), box2.getMax(i));
        }
        return new ModifiableHyperBoundingBox(min, max);
    }

    public static ModifiableHyperBoundingBox unionTolerant(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1 == null && mbr2 == null) {
            return null;
        }
        if (mbr1 == null) {
            return new ModifiableHyperBoundingBox(mbr2);
        }
        if (mbr2 == null) {
            return new ModifiableHyperBoundingBox(mbr1);
        }
        return SpatialUtil.union(mbr1, mbr2);
    }

    public static <E extends SpatialComparable, A> double[] unionFlatMBR(A data, ArrayAdapter<E, ? super A> getter) {
        int num = getter.size(data);
        assert (num > 0) : "Cannot compute MBR of empty set.";
        SpatialComparable first = (SpatialComparable)getter.get(data, 0);
        int dim = first.getDimensionality();
        double[] mbr = new double[2 * dim];
        for (int d = 0; d < dim; ++d) {
            mbr[d] = first.getMin(d);
            mbr[dim + d] = first.getMax(d);
        }
        for (int i = 1; i < num; ++i) {
            SpatialComparable next = (SpatialComparable)getter.get(data, i);
            for (int d = 0; d < dim; ++d) {
                mbr[d] = Math.min(mbr[d], next.getMin(d));
                mbr[dim + d] = Math.max(mbr[dim + d], next.getMax(d));
            }
        }
        return mbr;
    }

    public static ModifiableHyperBoundingBox intersection(SpatialComparable box1, SpatialComparable box2) {
        int dim = SpatialUtil.assertSameDimensionality(box1, box2);
        double[] min = new double[dim];
        double[] max = new double[dim];
        for (int i = 0; i < dim; ++i) {
            min[i] = Math.max(box1.getMin(i), box2.getMin(i));
            max[i] = Math.min(box1.getMax(i), box2.getMax(i));
            if (!(min[i] > max[i])) continue;
            return null;
        }
        return new ModifiableHyperBoundingBox(min, max);
    }

    public static double[] centroid(SpatialComparable obj) {
        int dim = obj.getDimensionality();
        double[] centroid = new double[dim];
        for (int d = 0; d < dim; ++d) {
            centroid[d] = (obj.getMax(d) + obj.getMin(d)) * 0.5;
        }
        return centroid;
    }

    public static boolean equals(SpatialComparable box1, SpatialComparable box2) {
        if (box1.getDimensionality() != box2.getDimensionality()) {
            return false;
        }
        for (int i = 0; i < box1.getDimensionality(); ++i) {
            if (box1.getMin(i) != box2.getMin(i)) {
                return false;
            }
            if (box1.getMax(i) == box2.getMax(i)) continue;
            return false;
        }
        return true;
    }
}

