/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.synthetic.bymodel;

import de.lmu.ifi.dbs.elki.data.model.GeneratorModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorInterfaceDynamic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.AffineTransformation;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class GeneratorSingleCluster
implements GeneratorInterfaceDynamic {
    private List<Distribution> axes = new ArrayList<Distribution>();
    private AffineTransformation trans;
    private int dim;
    private double[] clipmin;
    private double[] clipmax;
    private double densitycorrection = 1.0;
    private int size;
    private String name;
    private int retries = 1000;
    private int discarded = 0;
    private Random random;

    public GeneratorSingleCluster(String name, int size, double densitycorrection, Random random) {
        this.size = size;
        this.name = name;
        this.densitycorrection = densitycorrection;
        this.random = random;
    }

    public void addGenerator(Distribution gen) {
        if (this.trans != null) {
            throw new AbortException("Generators may no longer be added when transformations have been applied.");
        }
        this.axes.add(gen);
        ++this.dim;
    }

    public void addRotation(int axis1, int axis2, double angle) {
        if (this.trans == null) {
            this.trans = new AffineTransformation(this.dim);
        }
        this.trans.addRotation(axis1, axis2, angle);
    }

    public void addTranslation(double[] v) {
        if (this.trans == null) {
            this.trans = new AffineTransformation(this.dim);
        }
        this.trans.addTranslation(v);
    }

    public void setClipping(double[] min, double[] max) {
        if (min.length == 1 && max.length == 1) {
            if (min[0] >= max[0]) {
                throw new AbortException("Clipping range empty.");
            }
            this.clipmin = new double[this.dim];
            this.clipmax = new double[this.dim];
            Arrays.fill(this.clipmin, min[0]);
            Arrays.fill(this.clipmax, max[0]);
            return;
        }
        if (this.dim != min.length) {
            throw new AbortException("Clipping double[] dimensionalities do not match: " + this.dim + " vs. " + min.length);
        }
        if (this.dim != max.length) {
            throw new AbortException("Clipping double[] dimensionalities do not match: " + this.dim + " vs. " + max.length);
        }
        for (int i = 0; i < this.dim; ++i) {
            if (!(min[i] >= max[i])) continue;
            throw new AbortException("Clipping range empty in dimension " + (i + 1));
        }
        this.clipmin = min;
        this.clipmax = max;
    }

    @Override
    public int getDim() {
        return this.dim;
    }

    private boolean testClipping(double[] p) {
        if (this.clipmin == null || this.clipmax == null) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i] < this.clipmin[i]) && !(p[i] > this.clipmax[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<double[]> generate(int count) {
        ArrayList<double[]> result = new ArrayList<double[]>(count);
        while (result.size() < count) {
            double[] d = new double[this.dim];
            for (int i = 0; i < this.dim; ++i) {
                d[i] = this.axes.get(i).nextRandom();
            }
            if (this.trans != null) {
                d = this.trans.apply(d);
            }
            if (this.testClipping(d)) {
                if (--this.retries >= 0) continue;
                throw new AbortException("Maximum retry count in generator exceeded.");
            }
            result.add(d);
        }
        return result;
    }

    @Override
    public double getDensity(double[] p) {
        if (this.trans != null) {
            p = this.trans.applyInverse(p);
        }
        double density = this.densitycorrection;
        for (int i = 0; i < this.dim; ++i) {
            density *= this.axes.get(i).pdf(p[i]);
        }
        return density;
    }

    public AffineTransformation getTransformation() {
        return this.trans;
    }

    public double[] getClipmin() {
        if (this.clipmin == null) {
            return null;
        }
        return this.clipmin;
    }

    public double[] getClipmax() {
        if (this.clipmax == null) {
            return null;
        }
        return this.clipmax;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getDiscarded() {
        return this.discarded;
    }

    @Override
    public void incrementDiscarded() {
        ++this.discarded;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public double getDensityCorrection() {
        return this.densitycorrection;
    }

    public void setDensityCorrection(double densitycorrection) {
        this.densitycorrection = densitycorrection;
    }

    public Random getNewRandomGenerator() {
        return new Random(this.random.nextLong());
    }

    @Override
    public Model makeModel() {
        return new GeneratorModel(this, this.computeMean());
    }

    public Distribution getDistribution(int i) {
        return this.axes.get(i);
    }

    @Override
    public double[] computeMean() {
        double[] v = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            v[i] = this.axes.get(i).quantile(0.5);
        }
        if (this.trans != null) {
            v = this.trans.apply(v);
        }
        return v;
    }
}

