/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;

public class SimpleTypeInformation<T>
implements TypeInformation {
    private Class<? super T> cls;
    private String label;
    private ByteBufferSerializer<? super T> serializer;

    public SimpleTypeInformation(Class<? super T> cls) {
        this.cls = cls;
        this.label = null;
        this.serializer = null;
    }

    public SimpleTypeInformation(Class<? super T> cls, String label) {
        this.cls = cls;
        this.label = label;
        this.serializer = null;
    }

    public SimpleTypeInformation(Class<? super T> cls, ByteBufferSerializer<? super T> serializer) {
        this.cls = cls;
        this.label = null;
        this.serializer = serializer;
    }

    public SimpleTypeInformation(Class<? super T> cls, String label, ByteBufferSerializer<? super T> serializer) {
        this.cls = cls;
        this.label = label;
        this.serializer = serializer;
    }

    public final Class<? super T> getRestrictionClass() {
        return this.cls;
    }

    @Override
    public boolean isAssignableFromType(TypeInformation type) {
        if (!(type instanceof SimpleTypeInformation)) {
            return false;
        }
        SimpleTypeInformation simpleType = (SimpleTypeInformation)type;
        return this.cls.isAssignableFrom(simpleType.getRestrictionClass());
    }

    @Override
    public boolean isAssignableFrom(Object other) {
        return this.cls.isInstance(other);
    }

    public T cast(Object other) {
        return this.cls.cast(other);
    }

    public String toString() {
        return this.getRestrictionClass().getSimpleName();
    }

    public String getLabel() {
        return this.label;
    }

    public ByteBufferSerializer<? super T> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ByteBufferSerializer<? super T> serializer) {
        this.serializer = serializer;
    }
}

