/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ClassInstantiationException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TypeInformationSerializer
implements ByteBufferSerializer<TypeInformation> {
    public static final TypeInformationSerializer STATIC = new TypeInformationSerializer();
    private static final byte TAG_SIMPLE = 0;
    private static final byte TAG_VECTOR = 1;
    private static final byte TAG_VECTOR_FIELD = 2;
    static final ByteBufferSerializer<SimpleTypeInformation<?>> SIMPLE_TYPE_SERIALIZER = new SimpleTypeSerializer();
    static final ByteBufferSerializer<VectorTypeInformation<?>> VECTOR_TYPE_SERIALIZER = new VectorTypeSerializer();
    static final ByteBufferSerializer<VectorFieldTypeInformation<?>> VECTOR_FIELD_TYPE_SERIALIZER = new VectorFieldTypeSerializer();

    @Override
    public TypeInformation fromByteBuffer(ByteBuffer buffer) throws IOException, UnsupportedOperationException {
        byte type = buffer.get();
        switch (type) {
            case 0: {
                return SIMPLE_TYPE_SERIALIZER.fromByteBuffer(buffer);
            }
            case 1: {
                return VECTOR_TYPE_SERIALIZER.fromByteBuffer(buffer);
            }
            case 2: {
                return VECTOR_FIELD_TYPE_SERIALIZER.fromByteBuffer(buffer);
            }
        }
        throw new UnsupportedOperationException("No deserialization known for type " + type);
    }

    @Override
    public void toByteBuffer(ByteBuffer buffer, TypeInformation object) throws IOException, UnsupportedOperationException {
        Class<?> clz = object.getClass();
        if (VectorFieldTypeInformation.class.equals(clz)) {
            buffer.put((byte)2);
            VECTOR_FIELD_TYPE_SERIALIZER.toByteBuffer(buffer, (VectorFieldTypeInformation)object);
            return;
        }
        if (VectorTypeInformation.class.equals(clz)) {
            buffer.put((byte)1);
            VECTOR_TYPE_SERIALIZER.toByteBuffer(buffer, (VectorTypeInformation)object);
            return;
        }
        if (SimpleTypeInformation.class.equals(clz)) {
            buffer.put((byte)0);
            SIMPLE_TYPE_SERIALIZER.toByteBuffer(buffer, (SimpleTypeInformation)object);
            return;
        }
        throw new UnsupportedOperationException("Unsupported type information.");
    }

    @Override
    public int getByteSize(TypeInformation object) throws IOException, UnsupportedOperationException {
        Class<?> clz = object.getClass();
        if (VectorFieldTypeInformation.class.equals(clz)) {
            return 1 + VECTOR_FIELD_TYPE_SERIALIZER.getByteSize((VectorFieldTypeInformation)object);
        }
        if (VectorTypeInformation.class.equals(clz)) {
            return 1 + VECTOR_TYPE_SERIALIZER.getByteSize((VectorTypeInformation)object);
        }
        if (SimpleTypeInformation.class.equals(clz)) {
            return 1 + SIMPLE_TYPE_SERIALIZER.getByteSize((SimpleTypeInformation)object);
        }
        throw new UnsupportedOperationException("Unsupported type information.");
    }

    static class VectorFieldTypeSerializer
    implements ByteBufferSerializer<VectorFieldTypeInformation<?>> {
        VectorFieldTypeSerializer() {
        }

        @Override
        public VectorFieldTypeInformation<?> fromByteBuffer(ByteBuffer buffer) throws IOException, UnsupportedOperationException {
            try {
                String typename = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                NumberVector.Factory factory = ClassGenericsUtil.instantiate(NumberVector.Factory.class, typename);
                String label = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                label = "".equals(label) ? null : label;
                String sername = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                ByteBufferSerializer serializer = (ByteBufferSerializer)Class.forName(sername).newInstance();
                int mindim = ByteArrayUtil.readSignedVarint(buffer);
                int maxdim = ByteArrayUtil.readSignedVarint(buffer);
                int cols = ByteArrayUtil.readUnsignedVarint(buffer);
                if (cols > 0) {
                    assert (mindim == maxdim && maxdim == cols) : "Inconsistent dimensionality and column names!";
                    String[] labels = new String[cols];
                    for (int i = 0; i < cols; ++i) {
                        labels[i] = ByteArrayUtil.readString(buffer);
                    }
                    return new VectorFieldTypeInformation(factory, mindim, labels, serializer);
                }
                return new VectorFieldTypeInformation(factory, mindim, maxdim, serializer);
            }
            catch (ClassInstantiationException e) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate factory: " + e, e);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Cannot deserialize - class not found: " + e, e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate serializer: " + e.getMessage(), e);
            }
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, VectorFieldTypeInformation<?> object) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer serializer = object.getSerializer();
            if (serializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                serializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Serialization not possible.", e);
            }
            ByteArrayUtil.writeString(buffer, object.getFactory().getClass().getName());
            ByteArrayUtil.writeString(buffer, object.getLabel());
            ByteArrayUtil.writeString(buffer, serializer.getClass().getName());
            ByteArrayUtil.writeSignedVarint(buffer, object.mindim());
            ByteArrayUtil.writeSignedVarint(buffer, object.maxdim());
            String[] labels = object.getLabels();
            if (labels == null) {
                ByteArrayUtil.writeUnsignedVarint(buffer, 0);
            } else {
                ByteArrayUtil.writeUnsignedVarint(buffer, labels.length);
                for (String s : labels) {
                    ByteArrayUtil.writeString(buffer, s);
                }
            }
        }

        @Override
        public int getByteSize(VectorFieldTypeInformation<?> object) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer serializer = object.getSerializer();
            if (serializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                serializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Serialization not possible.", e);
            }
            int total = 0;
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(object.getRestrictionClass().getName());
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(object.getLabel());
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(serializer.getClass().getName());
            total += ByteArrayUtil.getSignedVarintSize(object.mindim());
            total += ByteArrayUtil.getSignedVarintSize(object.maxdim());
            String[] labels = object.getLabels();
            if (labels == null) {
                total += ByteArrayUtil.getUnsignedVarintSize(0);
            } else {
                total += ByteArrayUtil.getUnsignedVarintSize(labels.length);
                for (String s : labels) {
                    total += ByteArrayUtil.getStringSize(s);
                }
            }
            return total;
        }
    }

    static class VectorTypeSerializer
    implements ByteBufferSerializer<VectorTypeInformation<?>> {
        VectorTypeSerializer() {
        }

        @Override
        public VectorTypeInformation<?> fromByteBuffer(ByteBuffer buffer) throws IOException, UnsupportedOperationException {
            try {
                String typename = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                NumberVector.Factory factory = ClassGenericsUtil.instantiate(NumberVector.Factory.class, typename);
                String label = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                label = "".equals(label) ? null : label;
                String sername = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                ByteBufferSerializer serializer = (ByteBufferSerializer)Class.forName(sername).newInstance();
                int mindim = ByteArrayUtil.readSignedVarint(buffer);
                int maxdim = ByteArrayUtil.readSignedVarint(buffer);
                return new VectorTypeInformation(factory, serializer, mindim, maxdim);
            }
            catch (ClassInstantiationException e) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate factory: " + e, e);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Cannot deserialize - class not found: " + e, e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate serializer: " + e.getMessage(), e);
            }
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, VectorTypeInformation<?> object) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer serializer = object.getSerializer();
            if (serializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                serializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Serialization not possible.", e);
            }
            ByteArrayUtil.writeString(buffer, object.getFactory().getClass().getName());
            ByteArrayUtil.writeString(buffer, object.getLabel());
            ByteArrayUtil.writeString(buffer, serializer.getClass().getName());
            ByteArrayUtil.writeSignedVarint(buffer, object.mindim());
            ByteArrayUtil.writeSignedVarint(buffer, object.maxdim());
        }

        @Override
        public int getByteSize(VectorTypeInformation<?> object) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer serializer = object.getSerializer();
            if (serializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                serializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Serialization not possible.", e);
            }
            int total = 0;
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(object.getRestrictionClass().getName());
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(object.getLabel());
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(serializer.getClass().getName());
            total += ByteArrayUtil.getSignedVarintSize(object.mindim());
            return total += ByteArrayUtil.getSignedVarintSize(object.maxdim());
        }
    }

    static class SimpleTypeSerializer
    implements ByteBufferSerializer<SimpleTypeInformation<?>> {
        SimpleTypeSerializer() {
        }

        @Override
        public SimpleTypeInformation<?> fromByteBuffer(ByteBuffer buffer) throws IOException, UnsupportedOperationException {
            try {
                String typename = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                Class<?> clz = Class.forName(typename);
                String label = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                label = "".equals(label) ? null : label;
                String sername = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(buffer);
                ByteBufferSerializer serializer = (ByteBufferSerializer)Class.forName(sername).newInstance();
                return new SimpleTypeInformation(clz, label, serializer);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Cannot deserialize - class not found: " + e, e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnsupportedOperationException("Cannot deserialize - cannot instantiate serializer: " + e.getMessage(), e);
            }
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, SimpleTypeInformation<?> object) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer<?> serializer = object.getSerializer();
            if (serializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                serializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Serialization not possible.", e);
            }
            ByteArrayUtil.writeString(buffer, object.getRestrictionClass().getName());
            ByteArrayUtil.writeString(buffer, object.getLabel());
            ByteArrayUtil.writeString(buffer, serializer.getClass().getName());
        }

        @Override
        public int getByteSize(SimpleTypeInformation<?> object) throws IOException, UnsupportedOperationException {
            ByteBufferSerializer<?> serializer = object.getSerializer();
            if (serializer == null) {
                throw new UnsupportedOperationException("No serializer for type " + this.toString() + " available.");
            }
            try {
                serializer.getClass().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No automatic serialization possible - no default constructor for serializer.");
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Serialization not possible.", e);
            }
            int total = 0;
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(object.getRestrictionClass().getName());
            total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(object.getLabel());
            return total += ByteArrayUtil.STRING_SERIALIZER.getByteSize(serializer.getClass().getName());
        }
    }
}

