/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.type.FieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;

public class VectorFieldTypeInformation<V extends FeatureVector<?>>
extends VectorTypeInformation<V>
implements FieldTypeInformation {
    private String[] labels = null;

    public static <V extends FeatureVector<?>> VectorFieldTypeInformation<V> typeRequest(Class<? super V> cls) {
        return new VectorFieldTypeInformation<V>(cls, -1, Integer.MAX_VALUE);
    }

    public static <V extends FeatureVector<?>> VectorFieldTypeInformation<V> typeRequest(Class<? super V> cls, int mindim, int maxdim) {
        return new VectorFieldTypeInformation<V>(cls, mindim, maxdim);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int dim, String[] labels, ByteBufferSerializer<? super V> serializer) {
        super(factory, serializer, dim, dim);
        this.labels = labels;
        assert (labels == null || labels.length == dim) : "Created vector field with incomplete labels.";
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int mindim, int maxdim, ByteBufferSerializer<? super V> serializer) {
        super(factory, serializer, mindim, maxdim);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int dim, ByteBufferSerializer<? super V> serializer) {
        super(factory, serializer, dim, dim);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int dim, String[] labels) {
        super(factory, factory.getDefaultSerializer(), dim, dim);
        this.labels = labels;
        assert (labels == null || labels.length == dim) : "Created vector field with incomplete labels.";
    }

    private VectorFieldTypeInformation(Class<? super V> cls, int mindim, int maxdim) {
        super(cls, mindim, maxdim);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int dim) {
        super(factory, factory.getDefaultSerializer(), dim, dim);
    }

    @Override
    public boolean isAssignableFromType(TypeInformation type) {
        if (this == type) {
            return true;
        }
        if (!super.isAssignableFromType(type)) {
            return false;
        }
        VectorTypeInformation other = (VectorTypeInformation)type;
        return other.mindim == other.maxdim;
    }

    @Override
    public int getDimensionality() {
        if (this.mindim != this.maxdim) {
            throw new UnsupportedOperationException("Requesting dimensionality for a type request without defined dimensionality!");
        }
        return this.mindim;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(1000).append(this.getRestrictionClass().getSimpleName());
        if (this.mindim == this.maxdim) {
            buf.append(",dim=").append(this.mindim);
        } else {
            buf.append(",field");
            if (this.mindim >= 0) {
                buf.append(",mindim=").append(this.mindim);
            }
            if (this.maxdim < Integer.MAX_VALUE) {
                buf.append(",maxdim=").append(this.maxdim);
            }
        }
        return buf.toString();
    }

    public String getLabel(int col) {
        return this.labels == null ? null : this.labels[col];
    }

    protected String[] getLabels() {
        return this.labels;
    }
}

