/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;

public class VectorTypeInformation<V extends FeatureVector<?>>
extends SimpleTypeInformation<V> {
    private final FeatureVector.Factory<V, ?> factory;
    protected final int mindim;
    protected final int maxdim;

    public static <V extends FeatureVector<?>> VectorTypeInformation<V> typeRequest(Class<? super V> cls) {
        return new VectorTypeInformation<V>(cls, -1, Integer.MAX_VALUE);
    }

    public static <V extends FeatureVector<?>> VectorTypeInformation<V> typeRequest(Class<? super V> cls, int mindim, int maxdim) {
        return new VectorTypeInformation<V>(cls, mindim, maxdim);
    }

    public VectorTypeInformation(Class<? super V> cls, int mindim, int maxdim) {
        super(cls);
        this.factory = null;
        assert (mindim <= maxdim);
        this.mindim = mindim;
        this.maxdim = maxdim;
    }

    public VectorTypeInformation(FeatureVector.Factory<V, ?> factory, ByteBufferSerializer<? super V> serializer, int mindim, int maxdim) {
        super(factory.getRestrictionClass(), serializer);
        this.factory = factory;
        assert (mindim <= maxdim);
        this.mindim = mindim;
        this.maxdim = maxdim;
    }

    @Override
    public boolean isAssignableFromType(TypeInformation type) {
        if (!super.isAssignableFromType(type) || !(type instanceof VectorTypeInformation)) {
            return false;
        }
        VectorTypeInformation othertype = (VectorTypeInformation)type;
        assert (othertype.mindim <= othertype.maxdim);
        if (this.mindim > othertype.mindim) {
            return false;
        }
        return othertype.maxdim <= this.maxdim;
    }

    @Override
    public boolean isAssignableFrom(Object other) {
        if (!super.isAssignableFrom(other)) {
            return false;
        }
        int odim = ((FeatureVector)this.cast(other)).getDimensionality();
        return odim >= this.mindim && odim <= this.maxdim;
    }

    public FeatureVector.Factory<V, ?> getFactory() {
        if (this.factory == null) {
            throw new UnsupportedOperationException("Requesting factory for a type request!");
        }
        return this.factory;
    }

    public int mindim() {
        if (this.mindim < 0) {
            throw new UnsupportedOperationException("Requesting dimensionality for a request without defined dimensionality!");
        }
        return this.mindim;
    }

    public int maxdim() {
        if (this.maxdim == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Requesting dimensionality for a request without defined dimensionality!");
        }
        return this.maxdim;
    }

    public int getMultiplicity() {
        return 1;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(1000).append(super.toString()).append(",variable");
        if (this.mindim >= 0) {
            buf.append(",mindim=").append(this.mindim);
        }
        if (this.maxdim < Integer.MAX_VALUE) {
            buf.append(",maxdim=").append(this.maxdim);
        }
        return buf.toString();
    }
}

