/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import java.util.Random;

public abstract class AbstractUncertainObject
implements UncertainObject {
    public static final int DEFAULT_TRY_LIMIT = 1000;
    protected SpatialComparable bounds;

    protected static HyperBoundingBox computeBounds(NumberVector[] samples) {
        assert (samples.length > 0) : "Cannot compute bounding box of empty set.";
        int dimensions = samples[0].getDimensionality();
        double[] min = new double[dimensions];
        double[] max = new double[dimensions];
        NumberVector first = samples[0];
        for (int d = 0; d < dimensions; ++d) {
            min[d] = max[d] = first.doubleValue(d);
        }
        for (int i = 1; i < samples.length; ++i) {
            NumberVector v = samples[i];
            for (int d = 0; d < dimensions; ++d) {
                double c = v.doubleValue(d);
                min[d] = c < min[d] ? c : min[d];
                max[d] = c > max[d] ? c : max[d];
            }
        }
        return new HyperBoundingBox(min, max);
    }

    @Override
    public abstract DoubleVector drawSample(Random var1);

    @Override
    public int getDimensionality() {
        return this.bounds.getDimensionality();
    }

    @Override
    public double getMin(int dimension) {
        return this.bounds.getMin(dimension);
    }

    @Override
    public double getMax(int dimension) {
        return this.bounds.getMax(dimension);
    }

    @Override
    public Double getValue(int dimension) {
        return (this.bounds.getMax(dimension) + this.bounds.getMin(dimension)) * 0.5;
    }

    @Override
    public abstract DoubleVector getCenterOfMass();
}

