/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

public class SimpleGaussianContinuousUncertainObject
extends AbstractUncertainObject {
    public static final FeatureVector.Factory<SimpleGaussianContinuousUncertainObject, ?> FACTORY = new Factory();
    private static final double DIV = 0.16666666666666666;

    public SimpleGaussianContinuousUncertainObject(SpatialComparable bounds) {
        this.bounds = bounds;
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int dim = this.bounds.getDimensionality();
        double[] mean = new double[dim];
        for (int d = 0; d < dim; ++d) {
            mean[d] = (this.bounds.getMin(d) + this.bounds.getMax(d)) * 0.5;
        }
        return DoubleVector.wrap(mean);
    }

    @Override
    public DoubleVector drawSample(Random rand) {
        int dim = this.bounds.getDimensionality();
        double[] values = new double[dim];
        int i = 0;
        int maxtries = 1000;
        while (i < dim) {
            double l = this.bounds.getMin(i);
            double u = this.bounds.getMax(i);
            double s = (u - l) * 0.16666666666666666;
            assert (s < Double.POSITIVE_INFINITY);
            double v = rand.nextGaussian() * s + (l + u) * 0.5;
            if (v < l || v > u) {
                if (--maxtries != 0) continue;
                throw new AbortException("Could not satisfy bounding box!");
            }
            values[i++] = v;
        }
        return DoubleVector.wrap(values);
    }

    private static class Factory
    implements FeatureVector.Factory<SimpleGaussianContinuousUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> SimpleGaussianContinuousUncertainObject newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<SimpleGaussianContinuousUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super SimpleGaussianContinuousUncertainObject> getRestrictionClass() {
            return SimpleGaussianContinuousUncertainObject.class;
        }
    }
}

