/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

public class UniformContinuousUncertainObject
extends AbstractUncertainObject {
    public static final FeatureVector.Factory<UniformContinuousUncertainObject, ?> FACTORY = new Factory();

    public UniformContinuousUncertainObject(SpatialComparable bounds) {
        this.bounds = bounds;
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int dim = this.bounds.getDimensionality();
        double[] mean = new double[dim];
        for (int d = 0; d < dim; ++d) {
            mean[d] = (this.bounds.getMin(d) + this.bounds.getMax(d)) * 0.5;
        }
        return DoubleVector.wrap(mean);
    }

    @Override
    public DoubleVector drawSample(Random rand) {
        int dim = this.bounds.getDimensionality();
        double[] values = new double[dim];
        for (int i = 0; i < dim; ++i) {
            double w = this.bounds.getMax(i) - this.bounds.getMin(i);
            assert (w < Double.POSITIVE_INFINITY);
            values[i] = rand.nextDouble() * w + this.bounds.getMin(i);
        }
        return DoubleVector.wrap(values);
    }

    private static class Factory
    implements FeatureVector.Factory<UniformContinuousUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> UniformContinuousUncertainObject newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<UniformContinuousUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super UniformContinuousUncertainObject> getRestrictionClass() {
            return UniformContinuousUncertainObject.class;
        }
    }
}

