/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

@References(value={@Reference(authors="N. Dalvi, C. R\u00e9, D. Suciu", title="Probabilistic databases: diamonds in the dirt", booktitle="Communications of the ACM 52, 7", url="https://doi.org/10.1145/1538788.1538810", bibkey="DBLP:journals/cacm/DalviRS09"), @Reference(authors="O. Benjelloun, A. D. Sarma, A. Halevy, J. Widom", title="ULDBs: Databases with uncertainty and lineage", booktitle="Proc. of the 32nd Int. Conf. on Very Large Data Bases (VLDB)", url="http://www.vldb.org/conf/2006/p953-benjelloun.pdf", bibkey="DBLP:conf/vldb/BenjellounSHW06")})
public class UnweightedDiscreteUncertainObject
extends AbstractUncertainObject
implements DiscreteUncertainObject {
    public static final FeatureVector.Factory<UnweightedDiscreteUncertainObject, ?> FACTORY = new Factory();
    private DoubleVector[] samples;

    public UnweightedDiscreteUncertainObject(DoubleVector[] samples) {
        if (samples.length == 0) {
            throw new AbortException("Discrete Uncertain Objects must have at least one point.");
        }
        this.samples = samples;
        this.bounds = UnweightedDiscreteUncertainObject.computeBounds(samples);
    }

    @Override
    public DoubleVector drawSample(Random rand) {
        return this.samples[rand.nextInt(this.samples.length)];
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int dim = this.getDimensionality();
        double[] meanVals = new double[dim];
        for (int i = 0; i < this.samples.length; ++i) {
            DoubleVector vals = this.samples[i];
            for (int d = 0; d < dim; ++d) {
                int n = d;
                meanVals[n] = meanVals[n] + vals.doubleValue(d);
            }
        }
        return DoubleVector.wrap(VMath.timesEquals(meanVals, 1.0 / (double)this.samples.length));
    }

    @Override
    public int getNumberSamples() {
        return this.samples.length;
    }

    @Override
    public DoubleVector getSample(int i) {
        return this.samples[i];
    }

    @Override
    public double getWeight(int i) {
        return 1.0 / (double)this.samples.length;
    }

    private static class Factory
    implements FeatureVector.Factory<UnweightedDiscreteUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> UnweightedDiscreteUncertainObject newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<UnweightedDiscreteUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super UnweightedDiscreteUncertainObject> getRestrictionClass() {
            return UnweightedDiscreteUncertainObject.class;
        }
    }
}

