/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

@References(value={@Reference(authors="N. Dalvi, C. R\u00e9, D. Suciu", title="Probabilistic databases: diamonds in the dirt", booktitle="Communications of the ACM 52, 7", url="https://doi.org/10.1145/1538788.1538810", bibkey="DBLP:journals/cacm/DalviRS09"), @Reference(authors="O. Benjelloun, A. D. Sarma, A. Halevy, J. Widom", title="ULDBs: Databases with uncertainty and lineage", booktitle="Proc. of the 32nd Int. Conf. on Very Large Data Bases (VLDB)", url="http://www.vldb.org/conf/2006/p953-benjelloun.pdf", bibkey="DBLP:conf/vldb/BenjellounSHW06"), @Reference(authors="Thomas Bernecker, Hans-Peter Kriegel, Matthias Renz, Florian Verhein, Andreas Z\u00fcfle", title="Probabilistic frequent itemset mining in uncertain databases", booktitle="Proc. 15th ACM SIGKDD Int. Conf. on Knowledge Discovery and Data Mining", url="https://doi.org/10.1145/1557019.1557039", bibkey="DBLP:conf/kdd/BerneckerKRVZ09")})
public class WeightedDiscreteUncertainObject
extends AbstractUncertainObject
implements DiscreteUncertainObject {
    public static final FeatureVector.Factory<WeightedDiscreteUncertainObject, ?> FACTORY = new Factory();
    private DoubleVector[] samples;
    private double[] weights;

    public WeightedDiscreteUncertainObject(DoubleVector[] samples, double[] weights) {
        if (samples.length == 0) {
            throw new AbortException("Discrete Uncertain Objects must have at least one point.");
        }
        double check = 0.0;
        for (double weight : weights) {
            if (!(weight > 0.0) || !(weight < 1.0)) {
                throw new IllegalArgumentException("Probabilities must be in ]0:1], but is " + weight);
            }
            check += weight;
        }
        if (!(check > 0.0) || !(check <= 1.0000001)) {
            throw new IllegalArgumentException("Probability totals must be in ]0:1], but total is " + check);
        }
        this.samples = samples;
        this.bounds = WeightedDiscreteUncertainObject.computeBounds(samples);
        this.weights = weights;
    }

    @Override
    public DoubleVector drawSample(Random rand) {
        double r;
        int index = this.weights.length;
        for (r = rand.nextDouble(); --index >= 0 && r < this.weights[index]; r -= this.weights[index]) {
        }
        if (index < 0) {
            if (r < Double.MIN_NORMAL * (double)this.samples.length) {
                index = rand.nextInt(this.samples.length);
            } else {
                return null;
            }
        }
        return this.samples[index];
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int dim = this.getDimensionality();
        double[] meanVals = new double[dim];
        double weightSum = 0.0;
        for (int i = 0; i < this.samples.length; ++i) {
            DoubleVector v = this.samples[i];
            double w = this.weights[i];
            for (int d = 0; d < dim; ++d) {
                int n = d;
                meanVals[n] = meanVals[n] + v.doubleValue(d) * w;
            }
            weightSum += w;
        }
        int d = 0;
        while (d < dim) {
            int n = d++;
            meanVals[n] = meanVals[n] / weightSum;
        }
        return DoubleVector.wrap(meanVals);
    }

    @Override
    public int getNumberSamples() {
        return this.samples.length;
    }

    @Override
    public DoubleVector getSample(int i) {
        return this.samples[i];
    }

    @Override
    public double getWeight(int i) {
        return this.weights[i];
    }

    private static class Factory
    implements FeatureVector.Factory<WeightedDiscreteUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> WeightedDiscreteUncertainObject newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<WeightedDiscreteUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super WeightedDiscreteUncertainObject> getRestrictionClass() {
            return WeightedDiscreteUncertainObject.class;
        }
    }
}

