/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractDiscreteUncertainifier<UO extends UncertainObject>
implements Uncertainifier<UO> {
    protected Uncertainifier<?> inner;
    protected int minQuant;
    protected int maxQuant;

    public AbstractDiscreteUncertainifier(Uncertainifier<?> inner, int minQuant, int maxQuant) {
        this.inner = inner;
        this.minQuant = minQuant;
        this.maxQuant = maxQuant;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final int DEFAULT_SAMPLE_SIZE = 10;
        public static final OptionID INNER_ID = new OptionID("uo.discrete.generator", "Class to generate the point distribution.");
        public static final OptionID MULT_MAX_ID = new OptionID("uo.quantity.max", "Maximum points per uncertain object.");
        public static final OptionID MULT_MIN_ID = new OptionID("uo.quantity.min", "Minimum points per uncertain object (defaults to maximum.");
        protected Uncertainifier<?> inner;
        protected int minQuant;
        protected int maxQuant;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter pmultMin;
            IntParameter pmultMax;
            super.makeOptions(config);
            ObjectParameter innerP = new ObjectParameter(INNER_ID, Uncertainifier.class);
            if (config.grab(innerP)) {
                this.inner = (Uncertainifier)innerP.instantiateClass(config);
                if (this.inner instanceof AbstractDiscreteUncertainifier) {
                    LoggingUtil.warning("Using a discrete uncertainifier inside a discrete uncertainifier is likely a configuration error, and is likely to produce too many duplicate points. Did you mean to use a uniform or gaussian distribution instead?");
                }
            }
            if (config.grab(pmultMax = new IntParameter(MULT_MAX_ID, 10))) {
                this.maxQuant = pmultMax.intValue();
            }
            this.minQuant = config.grab(pmultMin = (IntParameter)new IntParameter(MULT_MIN_ID).setOptional(true)) ? pmultMin.intValue() : this.maxQuant;
        }
    }
}

