/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.uncertain.UniformContinuousUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.Random;

public class UniformUncertainifier
implements Uncertainifier<UniformContinuousUncertainObject> {
    double minDev;
    double maxDev;
    boolean symmetric;

    public UniformUncertainifier(double minDev, double maxDev, boolean symmetric) {
        this.minDev = minDev;
        this.maxDev = maxDev;
        this.symmetric = symmetric;
    }

    @Override
    public <A> UniformContinuousUncertainObject newFeatureVector(Random rand, A array, NumberArrayAdapter<?, A> adapter) {
        int dim = adapter.size(array);
        double[] min = new double[dim];
        double[] max = new double[dim];
        if (this.symmetric) {
            for (int i = 0; i < dim; ++i) {
                double v = adapter.getDouble(array, i);
                double width = rand.nextDouble() * (this.maxDev - this.minDev) + this.minDev;
                min[i] = v - width;
                max[i] = v + width;
            }
        } else {
            for (int i = 0; i < dim; ++i) {
                double v = adapter.getDouble(array, i);
                min[i] = v - (rand.nextDouble() * (this.maxDev - this.minDev) + this.minDev);
                max[i] = v + (rand.nextDouble() * (this.maxDev - this.minDev) + this.minDev);
            }
        }
        return new UniformContinuousUncertainObject(new HyperBoundingBox(min, max));
    }

    @Override
    public FeatureVector.Factory<UniformContinuousUncertainObject, ?> getFactory() {
        return UniformContinuousUncertainObject.FACTORY;
    }

    public static final class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DEV_MIN_ID = new OptionID("uo.uncertainty.min", "Minimum deviation of uncertain bounding box.");
        public static final OptionID DEV_MAX_ID = new OptionID("uo.uncertainty.max", "Maximum deviation of uncertain bounding box.");
        protected double minDev;
        protected double maxDev;
        protected boolean symmetric;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag symmetricF;
            DoubleParameter pmaxDev;
            super.makeOptions(config);
            DoubleParameter pminDev = new DoubleParameter(DEV_MIN_ID, 0.0);
            if (config.grab(pminDev)) {
                this.minDev = (Double)pminDev.getValue();
            }
            if (config.grab(pmaxDev = new DoubleParameter(DEV_MAX_ID))) {
                this.maxDev = (Double)pmaxDev.getValue();
            }
            if (config.grab(symmetricF = new Flag(Uncertainifier.SYMMETRIC_ID))) {
                this.symmetric = symmetricF.isTrue();
            }
        }

        @Override
        protected UniformUncertainifier makeInstance() {
            return new UniformUncertainifier(this.minDev, this.maxDev, this.symmetric);
        }
    }
}

