/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.uncertain.UnweightedDiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.AbstractDiscreteUncertainifier;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import java.util.Random;

public class UnweightedDiscreteUncertainifier
extends AbstractDiscreteUncertainifier<UnweightedDiscreteUncertainObject> {
    public UnweightedDiscreteUncertainifier(Uncertainifier<?> inner, int minQuant, int maxQuant) {
        super(inner, minQuant, maxQuant);
    }

    @Override
    public <A> UnweightedDiscreteUncertainObject newFeatureVector(Random rand, A array, NumberArrayAdapter<?, A> adapter) {
        Object uo = this.inner.newFeatureVector(rand, array, adapter);
        int distributionSize = rand.nextInt(this.maxQuant - this.minQuant + 1) + this.minQuant;
        DoubleVector[] samples = new DoubleVector[distributionSize];
        for (int i = 0; i < distributionSize; ++i) {
            samples[i] = uo.drawSample(rand);
        }
        return new UnweightedDiscreteUncertainObject(samples);
    }

    @Override
    public FeatureVector.Factory<UnweightedDiscreteUncertainObject, ?> getFactory() {
        return UnweightedDiscreteUncertainObject.FACTORY;
    }

    public static class Parameterizer
    extends AbstractDiscreteUncertainifier.Parameterizer {
        @Override
        protected UnweightedDiscreteUncertainifier makeInstance() {
            return new UnweightedDiscreteUncertainifier(this.inner, this.minQuant, this.maxQuant);
        }
    }
}

