/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.uncertain.WeightedDiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.AbstractDiscreteUncertainifier;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import java.util.Random;

public class WeightedDiscreteUncertainifier
extends AbstractDiscreteUncertainifier<WeightedDiscreteUncertainObject> {
    public WeightedDiscreteUncertainifier(Uncertainifier<?> inner, int minQuant, int maxQuant) {
        super(inner, minQuant, maxQuant);
    }

    @Override
    public <A> WeightedDiscreteUncertainObject newFeatureVector(Random rand, A array, NumberArrayAdapter<?, A> adapter) {
        int i;
        Object uo = this.inner.newFeatureVector(rand, array, adapter);
        int distributionSize = rand.nextInt(this.maxQuant - this.minQuant + 1) + this.minQuant;
        DoubleVector[] samples = new DoubleVector[distributionSize];
        double[] weights = new double[distributionSize];
        double wsum = 0.0;
        for (i = 0; i < distributionSize; ++i) {
            samples[i] = uo.drawSample(rand);
            double w = rand.nextDouble();
            while (w <= 0.0) {
                w = rand.nextDouble();
            }
            weights[i] = w;
            wsum += w;
        }
        assert (wsum > 0.0);
        i = 0;
        while (i < distributionSize) {
            int n = i++;
            weights[n] = weights[n] / wsum;
        }
        return new WeightedDiscreteUncertainObject(samples, weights);
    }

    @Override
    public FeatureVector.Factory<WeightedDiscreteUncertainObject, ?> getFactory() {
        return WeightedDiscreteUncertainObject.FACTORY;
    }

    public static class Parameterizer
    extends AbstractDiscreteUncertainifier.Parameterizer {
        @Override
        protected WeightedDiscreteUncertainifier makeInstance() {
            return new WeightedDiscreteUncertainifier(this.inner, this.minQuant, this.maxQuant);
        }
    }
}

