/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.ConvertToStringView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.distancematrix.PrecomputedDistanceMatrix;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static Relation<String> guessLabelRepresentation(Database database) throws NoSupportedDataTypeException {
        try {
            Relation classrep = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            if (classrep != null) {
                return new ConvertToStringView(classrep);
            }
        }
        catch (NoSupportedDataTypeException classrep) {
            // empty catch block
        }
        try {
            Relation labelsrep = database.getRelation(TypeUtil.LABELLIST, new Object[0]);
            if (labelsrep != null) {
                return new ConvertToStringView(labelsrep);
            }
        }
        catch (NoSupportedDataTypeException labelsrep) {
            // empty catch block
        }
        try {
            Relation<String> stringrep = database.getRelation(TypeUtil.STRING, new Object[0]);
            if (stringrep != null) {
                return stringrep;
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        throw new NoSupportedDataTypeException("No label-like representation was found.");
    }

    public static Relation<String> guessObjectLabelRepresentation(Database database) throws NoSupportedDataTypeException {
        try {
            Relation labelsrep = database.getRelation(TypeUtil.LABELLIST, new Object[0]);
            if (labelsrep != null) {
                return new ConvertToStringView(labelsrep);
            }
        }
        catch (NoSupportedDataTypeException labelsrep) {
            // empty catch block
        }
        try {
            Relation<String> stringrep = database.getRelation(TypeUtil.STRING, new Object[0]);
            if (stringrep != null) {
                return stringrep;
            }
        }
        catch (NoSupportedDataTypeException stringrep) {
            // empty catch block
        }
        try {
            Relation classrep = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            if (classrep != null) {
                return new ConvertToStringView(classrep);
            }
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            // empty catch block
        }
        throw new NoSupportedDataTypeException("No label-like representation was found.");
    }

    public static SortedSet<ClassLabel> getClassLabels(Relation<? extends ClassLabel> database) {
        TreeSet<ClassLabel> labels = new TreeSet<ClassLabel>();
        DBIDIter it = database.iterDBIDs();
        while (it.valid()) {
            labels.add(database.get(it));
            it.advance();
        }
        return labels;
    }

    public static SortedSet<ClassLabel> getClassLabels(Database database) {
        Relation relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
        return DatabaseUtil.getClassLabels(relation);
    }

    public static ArrayModifiableDBIDs getObjectsByLabelMatch(Database database, Pattern name_pattern) {
        Relation<String> relation = DatabaseUtil.guessLabelRepresentation(database);
        if (name_pattern == null) {
            return DBIDUtil.newArray();
        }
        ArrayModifiableDBIDs ret = DBIDUtil.newArray();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            if (name_pattern.matcher(relation.get(iditer)).find()) {
                ret.add(iditer);
            }
            iditer.advance();
        }
        return ret;
    }

    public static <O> KNNQuery<O> precomputedKNNQuery(Database database, Relation<O> relation, DistanceQuery<O> dq, int k) {
        KNNQuery<O> knnq = database.getKNNQuery(dq, k, "heavy", "optimized");
        if (knnq instanceof PreprocessorKNNQuery) {
            return knnq;
        }
        MaterializeKNNPreprocessor<O> preproc = new MaterializeKNNPreprocessor<O>(relation, dq.getDistanceFunction(), k);
        preproc.initialize();
        return preproc.getKNNQuery(dq, k);
    }

    public static <O> KNNQuery<O> precomputedKNNQuery(Database database, Relation<O> relation, DistanceFunction<? super O> distf, int k) {
        DistanceQuery<O> dq = database.getDistanceQuery(relation, distf, new Object[0]);
        KNNQuery<? super O> knnq = database.getKNNQuery(dq, k, "heavy", "optimized");
        if (knnq instanceof PreprocessorKNNQuery) {
            return knnq;
        }
        MaterializeKNNPreprocessor<O> preproc = new MaterializeKNNPreprocessor<O>(relation, dq.getDistanceFunction(), k);
        preproc.initialize();
        return preproc.getKNNQuery(dq, k);
    }

    public static <O> DistanceQuery<O> precomputedDistanceQuery(Database database, Relation<O> relation, DistanceFunction<? super O> distf, Logging log) {
        DBIDs ids;
        DistanceQuery<? super O> dq = database.getDistanceQuery(relation, distf, "heavy", "optimized");
        if (dq == null && (ids = relation.getDBIDs()) instanceof DBIDRange) {
            log.verbose("Precomputing a distance matrix for acceleration.");
            PrecomputedDistanceMatrix<? super O> idx = new PrecomputedDistanceMatrix<O>(relation, (DBIDRange)ids, distf);
            idx.initialize();
            dq = idx.getDistanceQuery(distf, new Object[0]);
        }
        if (dq == null) {
            dq = database.getDistanceQuery(relation, distf, "heavy");
            log.warning("We could not automatically use a distance matrix, expect a performance degradation.");
        }
        return dq;
    }
}

