/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.LinearScanDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.LinearScanEuclideanDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.LinearScanPrimitiveDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanEuclideanDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanPrimitiveDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanPrimitiveSimilarityRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanSimilarityRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.PrimitiveSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;

public final class QueryUtil {
    private QueryUtil() {
    }

    public static <O> DistanceQuery<O> getDistanceQuery(Database database, DistanceFunction<? super O> distanceFunction, Object ... hints) {
        Relation objectQuery = database.getRelation(distanceFunction.getInputTypeRestriction(), hints);
        return database.getDistanceQuery(objectQuery, distanceFunction, hints);
    }

    public static <O> SimilarityQuery<O> getSimilarityQuery(Database database, SimilarityFunction<? super O> similarityFunction, Object ... hints) {
        Relation objectQuery = database.getRelation(similarityFunction.getInputTypeRestriction(), hints);
        return database.getSimilarityQuery(objectQuery, similarityFunction, hints);
    }

    public static <O> KNNQuery<O> getKNNQuery(Database database, DistanceFunction<? super O> distanceFunction, Object ... hints) {
        Relation<Object> relation = database.getRelation(distanceFunction.getInputTypeRestriction(), hints);
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, hints);
        return relation.getKNNQuery(distanceQuery, hints);
    }

    public static <O> KNNQuery<O> getKNNQuery(Relation<O> relation, DistanceFunction<? super O> distanceFunction, Object ... hints) {
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, hints);
        return relation.getKNNQuery(distanceQuery, hints);
    }

    public static <O> RangeQuery<O> getRangeQuery(Database database, DistanceFunction<? super O> distanceFunction, Object ... hints) {
        Relation<Object> relation = database.getRelation(distanceFunction.getInputTypeRestriction(), hints);
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, hints);
        return relation.getRangeQuery(distanceQuery, hints);
    }

    public static <O> RangeQuery<O> getRangeQuery(Relation<O> relation, DistanceFunction<? super O> distanceFunction, Object ... hints) {
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, hints);
        return relation.getRangeQuery(distanceQuery, hints);
    }

    public static <O> RKNNQuery<O> getRKNNQuery(Relation<O> relation, DistanceFunction<? super O> distanceFunction, Object ... hints) {
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, hints);
        return relation.getRKNNQuery(distanceQuery, hints);
    }

    public static <O> KNNQuery<O> getLinearScanKNNQuery(DistanceQuery<O> distanceQuery) {
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery pdq = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistanceFunction.STATIC.equals(pdq.getDistanceFunction())) {
                PrimitiveDistanceQuery ndq = pdq;
                return new LinearScanEuclideanDistanceKNNQuery(ndq);
            }
            return new LinearScanPrimitiveDistanceKNNQuery(pdq);
        }
        return new LinearScanDistanceKNNQuery<O>(distanceQuery);
    }

    public static <O> RangeQuery<O> getLinearScanRangeQuery(DistanceQuery<O> distanceQuery) {
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery pdq = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistanceFunction.STATIC.equals(pdq.getDistanceFunction())) {
                PrimitiveDistanceQuery ndq = pdq;
                return new LinearScanEuclideanDistanceRangeQuery(ndq);
            }
            return new LinearScanPrimitiveDistanceRangeQuery(pdq);
        }
        return new LinearScanDistanceRangeQuery<O>(distanceQuery);
    }

    public static <O> RangeQuery<O> getLinearScanSimilarityRangeQuery(SimilarityQuery<O> simQuery) {
        if (simQuery instanceof PrimitiveSimilarityQuery) {
            PrimitiveSimilarityQuery pdq = (PrimitiveSimilarityQuery)simQuery;
            return new LinearScanPrimitiveSimilarityRangeQuery(pdq);
        }
        return new LinearScanSimilarityRangeQuery<O>(simQuery);
    }
}

