/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreFactory;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.IntegerDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import java.util.Comparator;

public final class DataStoreUtil {
    private DataStoreUtil() {
    }

    public static <T> WritableDataStore<T> makeStorage(DBIDs ids, int hints, Class<? super T> dataclass) {
        return DataStoreFactory.FACTORY.makeStorage(ids, hints, dataclass);
    }

    public static WritableDBIDDataStore makeDBIDStorage(DBIDs ids, int hints) {
        return DataStoreFactory.FACTORY.makeDBIDStorage(ids, hints);
    }

    public static WritableDoubleDataStore makeDoubleStorage(DBIDs ids, int hints) {
        return DataStoreFactory.FACTORY.makeDoubleStorage(ids, hints);
    }

    public static WritableDoubleDataStore makeDoubleStorage(DBIDs ids, int hints, double def) {
        return DataStoreFactory.FACTORY.makeDoubleStorage(ids, hints, def);
    }

    public static WritableIntegerDataStore makeIntegerStorage(DBIDs ids, int hints) {
        return DataStoreFactory.FACTORY.makeIntegerStorage(ids, hints);
    }

    public static WritableIntegerDataStore makeIntegerStorage(DBIDs ids, int hints, int def) {
        return DataStoreFactory.FACTORY.makeIntegerStorage(ids, hints, def);
    }

    public static WritableRecordStore makeRecordStorage(DBIDs ids, int hints, Class<?> ... dataclasses) {
        return DataStoreFactory.FACTORY.makeRecordStorage(ids, hints, dataclasses);
    }

    public static class DescendingByIntegerDataStore
    implements Comparator<DBIDRef> {
        private final IntegerDataStore scores;

        public DescendingByIntegerDataStore(IntegerDataStore scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            return Integer.compare(this.scores.intValue(id2), this.scores.intValue(id1));
        }
    }

    public static class AscendingByIntegerDataStore
    implements Comparator<DBIDRef> {
        private final IntegerDataStore scores;

        public AscendingByIntegerDataStore(IntegerDataStore scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            return Integer.compare(this.scores.intValue(id1), this.scores.intValue(id2));
        }
    }

    public static class DescendingByDoubleDataStoreAndId
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public DescendingByDoubleDataStoreAndId(DoubleDataStore scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            int c = Double.compare(this.scores.doubleValue(id2), this.scores.doubleValue(id1));
            return c != 0 ? c : DBIDUtil.compare(id1, id2);
        }
    }

    public static class AscendingByDoubleDataStoreAndId
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public AscendingByDoubleDataStoreAndId(DoubleDataStore scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            int c = Double.compare(this.scores.doubleValue(id1), this.scores.doubleValue(id2));
            return c != 0 ? c : DBIDUtil.compare(id1, id2);
        }
    }

    public static class DescendingByDoubleDataStore
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public DescendingByDoubleDataStore(DoubleDataStore scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            return Double.compare(this.scores.doubleValue(id2), this.scores.doubleValue(id1));
        }
    }

    public static class AscendingByDoubleDataStore
    implements Comparator<DBIDRef> {
        private final DoubleDataStore scores;

        public AscendingByDoubleDataStore(DoubleDataStore scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            return Double.compare(this.scores.doubleValue(id1), this.scores.doubleValue(id2));
        }
    }
}

