/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;

public class ArrayDBIDStore
implements WritableDBIDDataStore {
    private ArrayModifiableDBIDs data;
    private DataStoreIDMap idmap;

    public ArrayDBIDStore(int size, DataStoreIDMap idmap) {
        this.data = DBIDUtil.newArray(size);
        DBIDRef inv = DBIDUtil.invalid();
        for (int i = 0; i < size; ++i) {
            this.data.add(inv);
        }
        this.idmap = idmap;
    }

    @Override
    @Deprecated
    public DBID get(DBIDRef id) {
        return this.data.get(this.idmap.mapDBIDToOffset(id));
    }

    @Override
    public DBIDVar assignVar(DBIDRef id, DBIDVar var) {
        return this.data.assignVar(this.idmap.mapDBIDToOffset(id), var);
    }

    @Override
    @Deprecated
    public DBID put(DBIDRef id, DBID value) {
        int off = this.idmap.mapDBIDToOffset(id);
        DBID ret = this.data.get(off);
        this.data.set(off, value);
        return ret;
    }

    @Override
    public void putDBID(DBIDRef id, DBIDRef value) {
        this.data.set(this.idmap.mapDBIDToOffset(id), value);
    }

    @Override
    public void put(DBIDRef id, DBIDRef value) {
        this.data.set(this.idmap.mapDBIDToOffset(id), value);
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void clear() {
        DBIDRef inv = DBIDUtil.invalid();
        int size = this.data.size();
        this.data.clear();
        for (int i = 0; i < size; ++i) {
            this.data.add(inv);
        }
    }

    @Override
    public void delete(DBIDRef id) {
        this.put(id, DBIDUtil.invalid());
    }

    public String toString() {
        return this.data.toString();
    }
}

