/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import java.util.Arrays;

public class ArrayDoubleStore
implements WritableDoubleDataStore {
    private double[] data;
    private double def;
    private DataStoreIDMap idmap;

    public ArrayDoubleStore(int size, DataStoreIDMap idmap) {
        this(size, idmap, Double.NaN);
    }

    public ArrayDoubleStore(int size, DataStoreIDMap idmap, double def) {
        this.data = new double[size];
        if (def != 0.0) {
            Arrays.fill(this.data, def);
        }
        this.def = def;
        this.idmap = idmap;
    }

    @Override
    @Deprecated
    public Double get(DBIDRef id) {
        return this.data[this.idmap.mapDBIDToOffset(id)];
    }

    @Override
    @Deprecated
    public Double put(DBIDRef id, Double value) {
        int off = this.idmap.mapDBIDToOffset(id);
        double ret = this.data[off];
        this.data[off] = value;
        return ret;
    }

    @Override
    public double doubleValue(DBIDRef id) {
        return this.data[this.idmap.mapDBIDToOffset(id)];
    }

    @Override
    public double putDouble(DBIDRef id, double value) {
        int off = this.idmap.mapDBIDToOffset(id);
        double ret = this.data[off];
        this.data[off] = value;
        return ret;
    }

    @Override
    public double put(DBIDRef id, double value) {
        int off = this.idmap.mapDBIDToOffset(id);
        double ret = this.data[off];
        this.data[off] = value;
        return ret;
    }

    @Override
    public void increment(DBIDRef id, double value) {
        int n = this.idmap.mapDBIDToOffset(id);
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, this.def);
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void delete(DBIDRef id) {
        throw new UnsupportedOperationException("Can't delete from a static array storage.");
    }
}

