/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import java.util.Arrays;

public class ArrayIntegerStore
implements WritableIntegerDataStore {
    private int[] data;
    private DataStoreIDMap idmap;
    private int def;

    public ArrayIntegerStore(int size, DataStoreIDMap idmap) {
        this(size, idmap, 0);
    }

    public ArrayIntegerStore(int size, DataStoreIDMap idmap, int def) {
        this.data = new int[size];
        this.def = def;
        if (def != 0) {
            Arrays.fill(this.data, def);
        }
        this.idmap = idmap;
    }

    @Override
    @Deprecated
    public Integer get(DBIDRef id) {
        return this.data[this.idmap.mapDBIDToOffset(id)];
    }

    @Override
    @Deprecated
    public Integer put(DBIDRef id, Integer value) {
        int off = this.idmap.mapDBIDToOffset(id);
        int ret = this.data[off];
        this.data[off] = value;
        return ret;
    }

    @Override
    public int intValue(DBIDRef id) {
        return this.data[this.idmap.mapDBIDToOffset(id)];
    }

    @Override
    public int putInt(DBIDRef id, int value) {
        int off = this.idmap.mapDBIDToOffset(id);
        int ret = this.data[off];
        this.data[off] = value;
        return ret;
    }

    @Override
    public int put(DBIDRef id, int value) {
        int off = this.idmap.mapDBIDToOffset(id);
        int ret = this.data[off];
        this.data[off] = value;
        return ret;
    }

    @Override
    public void increment(DBIDRef id, int adjust) {
        int off;
        int n = off = this.idmap.mapDBIDToOffset(id);
        this.data[n] = this.data[n] + adjust;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void delete(DBIDRef id) {
        this.put(id, this.def);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, this.def);
    }
}

