/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;

public class ArrayRecordStore
implements WritableRecordStore {
    private final Object[][] data;
    private final DataStoreIDMap idmap;

    public ArrayRecordStore(Object[][] data, DataStoreIDMap idmap) {
        this.data = data;
        this.idmap = idmap;
    }

    @Override
    public <T> WritableDataStore<T> getStorage(int col, Class<? super T> datatype) {
        return new StorageAccessor(col);
    }

    protected <T> T get(DBIDRef id, int index) {
        return (T)this.data[this.idmap.mapDBIDToOffset(id)][index];
    }

    protected <T> T set(DBIDRef id, int index, T value) {
        Object ret = this.data[this.idmap.mapDBIDToOffset(id)][index];
        this.data[this.idmap.mapDBIDToOffset((DBIDRef)id)][index] = value;
        return (T)ret;
    }

    @Override
    public boolean remove(DBIDRef id) {
        throw new UnsupportedOperationException("ArrayStore records cannot be removed.");
    }

    protected class StorageAccessor<T>
    implements WritableDataStore<T> {
        private final int index;

        protected StorageAccessor(int index) {
            this.index = index;
        }

        @Override
        public T get(DBIDRef id) {
            return ArrayRecordStore.this.get(id, this.index);
        }

        @Override
        public T put(DBIDRef id, T value) {
            return ArrayRecordStore.this.set(id, this.index, value);
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException("ArrayStore record columns cannot (yet) be destroyed.");
        }

        @Override
        public void delete(DBIDRef id) {
            this.put(id, null);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("ArrayStore record columns cannot (yet) be cleared.");
        }
    }
}

